VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsTestSwedll32"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'=======================================================================
' Test subroutines for Swiss Ephemeris Visual Basic 32-bit API functions
' DLLFileName       :swedll32.dll
' DLLFileSize       :942,592 bytes
' DLLFileDateTime   :04/08/2021  14:04:22
' DLLFileType       :Dynamic link Library(32Bits)
' DLLFileVersion    :2.10.02
' --------------------------------------------------------------
' ThisFileName      :clsTestSwedll32.cls
' Created on        :14.10.2021
' Created by        :D.Senthilathiban (Email:athi_ram@yahoo.com)
'===============================================================
'
' from posting by D.Senthilathiban (Email:athi_ram@yahoo.com) in
' Swiss Ephemeris mailing list
'
' This file is in the Public Domain last updated on 14-Oct-2021
'
' The swedll32.dll file must exist in the same directory as the VB executable,
' or in a system directory where it can be found at runtime
'
' *********************CAUTION/WARNING:*************************************
' Test subroutines are written without any arguments and the required argument
' values for the respective Swiss Ephemeris Visual Basic 32-bit API functions
' are selected randomly as a default in respective subroutines for the purpose
' of testing only. However, the user may do changes as required.
'
' For more/updated details of functions/variables and Return values/Errors
' refer webpage https://www.astro.com/swisseph/swephprg.htm
' Programming interface to the Swiss Ephemeris Manual.
''**************************************************************************
'
'/*
'
'  License conditions
'  ------------------
'
'  This file is distributed with NO WARRANTY OF ANY KIND. No author/contributor
'  or distributor accepts any responsibility for the consequences of using it,
'  or for whether it serves any particular purpose or works at all.
'
'  The License grants you the right to use, copy, modify and redistribute,
'  but only under certain conditions that the File information, author/contributor
'  details and this notice be preserved on all copies.
'
'  The author/contributor have no control or influence over any of
'  the derived works, i.e. over software or services created by other
'  programmers which use Swiss Ephemeris functions.
'
'
'*/

Option Explicit

Public FileOUT As Integer 'flag to write results to a file or Debug mode
Private FileHEADER As Integer 'flag to write header to a file
Private sSWEPH_EPHE_PATH As String
Private sTESTFILEPATH As String

Public Property Let SwissFilePath(sPath As String)
If IsFolderExists(sPath) Then
    sSWEPH_EPHE_PATH = sPath
    Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
Else
    MsgBox sSWEPH_EPHE_PATH, vbCritical, "Folder doesn't exist"
End If
End Property

Public Property Get SwissFilePath() As String
SwissFilePath = sSWEPH_EPHE_PATH
End Property

Public Property Let TestFilePath(sPath As String)
sTESTFILEPATH = sPath
End Property

Public Property Get TestFilePath() As String
TestFilePath = sTESTFILEPATH
End Property

Private Sub PrintDetails(sText As String, Optional ByVal vValue As Variant)

Dim sFilePath As String
Dim iFileNo As Integer

If FileOUT And FileHEADER = 0 Then
    Call PrintHeader 'call PrintHeader for first time
    FileHEADER = 1   'flag to avoid calling PrintHeader next time
End If

sFilePath = sTESTFILEPATH
iFileNo = FreeFile
Open sFilePath For Append As #iFileNo

If IsMissing(vValue) Then
    If FileOUT Then
        Print #iFileNo, sText
    Else
        Debug.Print sText ' vValue
    End If
Else
    If FileOUT Then
        Print #iFileNo, sText; vValue
    Else
        Debug.Print sText; vValue
    End If
End If
Close #iFileNo
End Sub

Private Sub PrintHeader()
Dim sFilePath As String
Dim iFileNo As Integer
sFilePath = sTESTFILEPATH
iFileNo = FreeFile
Open sFilePath For Append As #iFileNo
'if the filesize is less than 325 bytes then write header else
'it assumes that the header is already written and ignore writing it.
If LOF(iFileNo) < 325 Then
    Print #iFileNo, "#####################################################################"
    Print #iFileNo, "This file is generated using subroutines given in clsTestSwedll32.cls"
    Print #iFileNo, "for Testing Swiss Ephemeris Visual Basic 32-bit API functions."
    Print #iFileNo, "Created by:D.Senthilathiban (Email:athi_ram@yahoo.com)"
    Print #iFileNo, "#####################################################################"
End If
Close #iFileNo
End Sub

Private Function IsFolderExists(ByVal strFolderName As String) As Boolean

If dir(strFolderName, vbDirectory) <> "" Then IsFolderExists = True

End Function

Public Sub Test1()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  898]:     ext_def(void) swe_azalt(double tjd_ut,int32 calc_flag,double *geopos,double atpress,double attemp,double *xin,double *xaz);
'8.14.      swe_azalt(), horizontal coordinates, azimuth, altitude
'computes the horizontal coordinates (azimuth and altitude) of a planet or
'a star from either ecliptical or equatorial coordinates.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==================="
PrintDetails "Test[1]:swe_azalt()"
PrintDetails "==================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim calc_flag As Long         '/* Flag for Calculation, SE_ECL2HOR or SE_EQU2HOR. See user's manual.*/
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim atpress As Double         '/* atmospheric pressure in mbar/hPa */
Dim attemp As Double          '// atmospheric temperature in degrees Celsius
Dim xin(3) As Double          '/* array of 3 doubles: position of body in either ecliptical or equatorial coordinates, depending on calc_flag
Dim xaz(3) As Double          '// return array of 3 doubles, containing azimuth, true altitude, apparent altitude

'if calc_flag = SE_ECL2HOR
' set xin[0] = ecl. long., xin[1] = ecl. lat., (xin[2] = distance (not required));
'Elseif calc_flag = SE_EQU2HOR
'set xin[0] = right ascension, xin[1] = declination, (xin[2] = distance (not required));

geopos(0) = 80# 'geograph. longitude, +Ve east
geopos(1) = 13# 'geograph. latitude +Ve north
geopos(2) = 0# 'geograph. height

PrintDetails "ecliptical coordinates to horizontal coordinates"

calc_flag = SE_ECL2HOR
xin(0) = 150.5  'ecl. long.
xin(1) = 5.5    'ecl. lat.
xin(2) = 0#     'distance (not required)
tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)

Call swe_azalt(tjd_ut, calc_flag, geopos(0), atpress, attemp, xin(0), xaz(0))

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "calc_flag=", calc_flag
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "xin(0)=", xin(0) '"ecl. long.="
PrintDetails "xin(1)=", xin(1) '"ecl. lat.="
PrintDetails "xin(2)=", xin(2)
PrintDetails "xaz(0)=", xaz(0)
PrintDetails "xaz(1)=", xaz(1)
PrintDetails "xaz(2)=", xaz(2)

PrintDetails "equatorial coordinates to horizontal coordinates"

calc_flag = SE_EQU2HOR
'assumed data
xin(0) = 155# 'xaz(0)  'right ascension (RA)
xin(1) = 15# 'xaz(1)  'Declination(Decl.)
xin(2) = 1# 'xaz(2)  'distance (not required)

Call swe_azalt(tjd_ut, calc_flag, geopos(0), atpress, attemp, xin(0), xaz(0))

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "calc_flag=", calc_flag
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "xin(0)=", xin(0) '"ecl. long.="
PrintDetails "xin(1)=", xin(1) '"ecl. lat.="
PrintDetails "xin(2)=", xin(2)
PrintDetails "xaz(0)=", xaz(0)
PrintDetails "xaz(1)=", xaz(1) 'true altitude
PrintDetails "xaz(2)=", xaz(2) 'Apparent altitude

'The return values are:
'     xaz[0] = azimuth, i.e. position degree, measured from the south point to west;
'     xaz[1] = true altitude above horizon in degrees;
'     xaz[2] = apparent (refracted) altitude above horizon in degrees.
'The apparent altitude of a body depends on the atmospheric pressure and temperature. If only the true altitude is required, these parameters can be neglected.
'If atpress is given the value 0, the function estimates the pressure from the geographical altitude given in geopos[2] and attemp. If geopos[2] is 0, atpress will be estimated for sea level.

End Sub 'Test1()

Public Sub Test2()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  907]:     ext_def(void) swe_azalt_rev(double tjd_ut,int32 calc_flag,double *geopos,double *xin,double *xout);
'8.15.      swe_azalt_rev()
'The function swe_azalt_rev() is not precisely the reverse of swe_azalt().
'It computes either ecliptical or equatorial coordinates from azimuth and true altitude.
'If only an apparent altitude is given, the true altitude has to be computed first with
'the function swe_refrac().
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[2]:swe_azalt_rev()"
PrintDetails "======================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim calc_flag As Long         '/* Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim xin(3) As Double          '/* array of 3 doubles: position of body in either ecliptical or equatorial coordinates, depending on calc_flag
Dim xout(2) As Double         '/* return array of 2 doubles for either ecliptic or equatorial coordinates, depending on calc_flag */

'if calc_flag = SE_HOR2ECL
'xout[0] = ecl. long., xout[1] = ecl. lat.
'Elseif calc_flag = SE_EQU2HOR
'xout[0] = right ascension, xout[1] = declination

geopos(0) = 80# 'geograph. longitude, +Ve east
geopos(1) = 13# 'geograph. latitude +Ve north
geopos(2) = 0# 'geograph. height

PrintDetails "horizontal coordinates to ecliptical coordinates"

calc_flag = SE_HOR2ECL
xin(0) = 105#   'azimith
xin(1) = 7#  'Altitude
xin(2) = 0#      '
tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)

Call swe_azalt_rev(tjd_ut, calc_flag, geopos(0), xin(0), xout(0))

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "calc_flag=", calc_flag
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "xin(0)=", xin(0)
PrintDetails "xin(1)=", xin(1)
PrintDetails "xin(2)=", xin(2)
PrintDetails "xout(0)=", xout(0)
PrintDetails "xout(1)=", xout(1)

PrintDetails "horizontal coordinates to equatorial coordinates"

calc_flag = SE_HOR2EQU

Call swe_azalt_rev(tjd_ut, calc_flag, geopos(0), xin(0), xout(0))

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "calc_flag=", calc_flag
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "xin(0)=", xin(0)
PrintDetails "xin(1)=", xin(1)
PrintDetails "xin(2)=", xin(2)
PrintDetails "xout(0)=", xout(0)
PrintDetails "xout(1)=", xout(1)

'// return array of 2 doubles for either ecliptic or
'// equatorial coordinates, depending on calc_flag
End Sub 'Test2()

Public Sub Test3()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  702]:     ext_def(int32) swe_calc(double tjd, int ipl, int32 iflag,double *xx,char *serr);
'3.1.  The call parameters
'compute positions of planets, asteroids, lunar nodes and apogees.
'tjd_et requires Ephemeris Time (more accurate: Terrestrial Time (TT))
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=================="
PrintDetails "Test[3]:swe_calc()"
PrintDetails "=================="

Dim tjd As Double             '//Julian Day Number, ET/TT
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim xx(6) As Double           '//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Dim spname As String
Dim lpCHARA As Long

tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd = tjd + swe_deltat(tjd)
iflag = 0 'set flag as required

For ipl = 0 To 11 '= body number
    spname = Space$(256) '
    serr = Space$(256) '
    lpCHARA = swe_get_planet_name_LPCHARA(ipl, spname)
    spname = GetStrFromLPCHARA(lpCHARA)

    lRet = swe_calc(tjd, ipl, iflag, xx(0), serr)
        
    PrintDetails "tjd=", tjd
    PrintDetails "ipl=", ipl
    PrintDetails "iflag=", iflag
    PrintDetails "xx(0)=", xx(0)
    PrintDetails "xx(1)=", xx(1)
    PrintDetails "xx(2)=", xx(2)
    PrintDetails "xx(3)=", xx(3)
    PrintDetails "xx(4)=", xx(4)
    PrintDetails "xx(5)=", xx(5)
    PrintDetails "serr=", TrimNullChar(serr)
    PrintDetails "lRet=", lRet
    PrintDetails "sPname=", spname
Next

End Sub 'Test3()

Public Sub Test4()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  710]:     ext_def(int32) swe_calc_pctr(double tjd, int32 ipl, int32 iplctr, int32 iflag, double *xxret, char *serr);
'3.         Planetary Positions: The functions swe_calc_ut(), swe_calc(), and swe_calc_pctr()
'calculates planetocentric positions of planets, i. e. positions as observed
'from some different planet, e.g. Jupiter-centric ephemerides. The function
'can actually calculate any object as observed from any other object,
'e.g. also the position of some asteroid as observed from another asteroid or
'from a planetary moon.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[4]:swe_calc_pctr()"
PrintDetails "======================="

Dim tjd As Double             '//Julian Day Number,ET/TT
Dim ipl As Long               '//fixed set of body numbers
Dim iplctr As Long            '// center object
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim xxret(6) As Double        '//array of 6 doubles for planetary positions, planetocentric, from TT
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Dim spname As String
Dim lpCHARA As Long


Call swe_set_ephe_path(sSWEPH_EPHE_PATH)

iplctr = SE_EARTH '14
tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd = tjd + swe_deltat(tjd)
iflag = 0 'set flag as required

For ipl = 0 To 11 '= body number
    spname = Space$(256) '
    serr = Space$(256) '
    lpCHARA = swe_get_planet_name_LPCHARA(ipl, spname)
    spname = GetStrFromLPCHARA(lpCHARA)

    lRet = swe_calc_pctr(tjd, ipl, iplctr, iflag, xxret(0), serr)
    
    PrintDetails "tjd=", tjd
    PrintDetails "ipl=", ipl
    PrintDetails "iplctr=", iplctr
    PrintDetails "iflag=", iflag
    PrintDetails "xxret(0)=", xxret(0)
    PrintDetails "xxret(1)=", xxret(1)
    PrintDetails "xxret(2)=", xxret(2)
    PrintDetails "xxret(3)=", xxret(3)
    PrintDetails "xxret(4)=", xxret(4)
    PrintDetails "xxret(5)=", xxret(5)
    PrintDetails "serr=", TrimNullChar(serr)
    PrintDetails "lRet=", lRet
    PrintDetails "sPname=", spname
Next
End Sub 'Test4()

Public Sub Test5()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  707]:     ext_def(int32) swe_calc_ut(double tjd_ut, int32 ipl, int32 iflag, double *xx, char *serr);
'3.1.  The call parameters
'compute positions of planets, asteroids, lunar nodes and apogees.
'tjd_ut requires Universal Time (UT).
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[5]:swe_calc_ut()"
PrintDetails "====================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim xx(6) As Double           '//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Dim spname As String, lpCHARA As Long

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
iflag = 0 'set flag as required

For ipl = 0 To 11 '= body number
    spname = Space$(256) '
    serr = Space$(256) '
    lpCHARA = swe_get_planet_name_LPCHARA(ipl, spname)
    spname = GetStrFromLPCHARA(lpCHARA)
    
    lRet = swe_calc_ut(tjd_ut, ipl, iflag, xx(0), serr)
    
    PrintDetails "tjd_ut=", tjd_ut
    PrintDetails "ipl=", ipl
    PrintDetails "iflag=", iflag
    PrintDetails "xx(0)=", xx(0)
    PrintDetails "xx(1)=", xx(1)
    PrintDetails "xx(2)=", xx(2)
    PrintDetails "xx(3)=", xx(3)
    PrintDetails "xx(4)=", xx(4)
    PrintDetails "xx(5)=", xx(5)
    PrintDetails "serr=", TrimNullChar(serr)
    PrintDetails "lRet=", lRet
    PrintDetails "sPname=", spname
Next

End Sub 'Test5()

Public Sub Test6()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  743]:     ext_def(void) swe_close(void);
'2.2.  swe_close()
'/* close Swiss Ephemeris */
'At the end of your computations you can release all resources (open files and allocated memory) used by the Swiss Ephemeris DLL.
'After swe_close(), no Swiss Ephemeris functions should be used unless you call swe_set_ephe_path() again and, if required, swe_set_jpl_file().
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==================="
PrintDetails "Test[6]:swe_close()"
PrintDetails "==================="

Call swe_close


End Sub 'Test6()

Public Sub Test7()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  966]:     ext_def(void) swe_cotrans(double *xpo, double *xpn, double eps);
'18.6.1.      swe_cotrans(): coordinate transformation,
'from ecliptic to equator or vice-versa
'/* equator -> ecliptic    : eps must be positive
'* ecliptic -> equator    : eps must be negative
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[7]:swe_cotrans()"
PrintDetails "====================="

Dim xpo(3) As Double          '/* Array of 3 doubles: long., lat., dist. to be converted; distance remains unchanged, can be set to 1.00 */
Dim xpn(3) As Double          '/* Array of 3 doubles: long., lat., dist. Result of the conversion */
Dim eps As Double             '//Obliquity of ecliptic, in Decimal degrees, equator -> ecliptic: +eps(+Ve) ,ecliptic -> equator : -eps (-Ve)


PrintDetails "/* equator -> ecliptic    : eps must be positive"
xpo(0) = 100#
xpo(1) = 5#
xpo(2) = 1#
eps = 23.45

Call swe_cotrans(xpo(0), xpn(0), eps)

PrintDetails "xpo(0)=", xpo(0)
PrintDetails "xpo(1)=", xpo(1)
PrintDetails "xpo(2)=", xpo(2)
PrintDetails "xpn(0)=", xpn(0)
PrintDetails "xpn(1)=", xpn(1)
PrintDetails "xpn(2)=", xpn(2)
PrintDetails "eps=", eps

PrintDetails "'* ecliptic -> equator    : eps must be negative"

xpo(0) = xpn(0) '100#
xpo(1) = xpn(1) '5#
xpo(2) = xpn(2) '1#
eps = -eps '-23.45

Call swe_cotrans(xpo(0), xpn(0), eps)

PrintDetails "xpo(0)=", xpo(0)
PrintDetails "xpo(1)=", xpo(1)
PrintDetails "xpo(2)=", xpo(2)
PrintDetails "xpn(0)=", xpn(0)
PrintDetails "xpn(1)=", xpn(1)
PrintDetails "xpn(2)=", xpn(2)
PrintDetails "eps=", eps

End Sub 'Test7()

Public Sub Test8()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  967]:     ext_def(void) swe_cotrans_sp(double *xpo, double *xpn, double eps);
'18.6.2.      swe_cotrans_sp(): coordinate transformation of
'position and speed, from ecliptic to equator or vice-versa
'/ * equator -> ecliptic   : eps must be positive
'* ecliptic -> equator    : eps must be negative
'* eps, long., lat., and speeds in long. and lat. are in degrees! */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================"
PrintDetails "Test[8]:swe_cotrans_sp()"
PrintDetails "========================"

Dim xpo(6) As Double          '/* Array of 6 doubles, input: long., lat., dist. and speeds in long., lat and dist. */
Dim xpn(6) As Double          '/* Array of 6 doubles, position and speed in new coordinate system */
Dim eps As Double             '//Obliquity of ecliptic, in Decimal degrees, equator -> ecliptic: +eps(+Ve) ,ecliptic -> equator : -eps (-Ve)


PrintDetails "/* equator -> ecliptic    : eps must be positive"

xpo(0) = 100#
xpo(1) = 5#
xpo(2) = 1#
xpo(3) = 1#
xpo(4) = 1#
xpo(5) = 1#
eps = 23.45

Call swe_cotrans_sp(xpo(0), xpn(0), eps)

PrintDetails "xpo(0)=", xpo(0)
PrintDetails "xpo(1)=", xpo(1)
PrintDetails "xpo(2)=", xpo(2)
PrintDetails "xpo(3)=", xpo(3)
PrintDetails "xpo(4)=", xpo(4)
PrintDetails "xpo(5)=", xpo(5)
PrintDetails "xpn(0)=", xpn(0)
PrintDetails "xpn(1)=", xpn(1)
PrintDetails "xpn(2)=", xpn(2)
PrintDetails "xpn(3)=", xpn(3)
PrintDetails "xpn(4)=", xpn(4)
PrintDetails "xpn(5)=", xpn(5)
PrintDetails "eps=", eps

PrintDetails "'* ecliptic -> equator    : eps must be negative"

xpo(0) = xpn(0) '100#
xpo(1) = xpn(1) '5#
xpo(2) = xpn(2) '1#
xpo(3) = xpn(3) '1#
xpo(4) = xpn(4) '1#
xpo(5) = xpn(5) '1#
eps = -eps '-23.45

Call swe_cotrans_sp(xpo(0), xpn(0), eps)

PrintDetails "xpo(0)=", xpo(0)
PrintDetails "xpo(1)=", xpo(1)
PrintDetails "xpo(2)=", xpo(2)
PrintDetails "xpo(3)=", xpo(3)
PrintDetails "xpo(4)=", xpo(4)
PrintDetails "xpo(5)=", xpo(5)
PrintDetails "xpn(0)=", xpn(0)
PrintDetails "xpn(1)=", xpn(1)
PrintDetails "xpn(2)=", xpn(2)
PrintDetails "xpn(3)=", xpn(3)
PrintDetails "xpn(4)=", xpn(4)
PrintDetails "xpn(5)=", xpn(5)
PrintDetails "eps=", eps

End Sub 'Test8()

Public Sub Test9()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1017]:     ext_def(char *) swe_cs2degstr(CSEC t, char *a);
'18.7.11.   Centiseconds -> degrees string
'/* does  suppress leading zeros in degrees */
'/* former function name: DegreeString() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[9]:swe_cs2degstr()"
PrintDetails "======================="

Dim t As Long                 '// value in Centiseconds
Dim a As String               '//TimeString of Size 256
a = Space$(256)               '//TimeString of Size 256
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

t = 10 * 360000 '10 degree in CentiSecs

lpCHARA = swe_cs2degstr_LPCHARA(t, a)

PrintDetails "t=", t
'PrintDetails "lpCHARA=", lpCHARA
sRetText = GetStrFromLPCHARA(lpCHARA)
PrintDetails "sRetText =", sRetText
PrintDetails "a=", TrimNullChar(a)

End Sub 'Test9()

Public Sub Test10()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1015]:     ext_def(char *) swe_cs2lonlatstr(CSEC t, char pchar, char mchar, char *s);
'18.7.10.   Centiseconds -> longitude or latitude string
'/* former function name: LonLatString() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==========================="
PrintDetails "Test[10]:swe_cs2lonlatstr()"
PrintDetails "==========================="

Dim t As Long                 '// value in Centiseconds
Dim pchar As Byte             '//Char for calculation
Dim mchar As Byte             '//used in Centiseconds -> longitude or latitude string
Dim s As String               '//longitude or latitude string
s = Space$(256)               '//longitude or latitude string
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

t = -10.555 * 360000 '10d33'18" degree in CentiSecs
pchar = Asc("") '176
mchar = Asc("-")

lpCHARA = swe_cs2lonlatstr_LPCHARA(t, pchar, mchar, s)

PrintDetails "t=", t
PrintDetails "pchar=", pchar
PrintDetails "mchar=", mchar
'PrintDetails "lpCHARA=", lpCHARA
sRetText = GetStrFromLPCHARA(lpCHARA)
PrintDetails "sRetText =", sRetText
PrintDetails "s=", TrimNullChar(s)

End Sub 'Test10()

Public Sub Test11()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1013]:     ext_def(char *) swe_cs2timestr(CSEC t, int sep, AS_BOOL suppressZero, char *a);
'18.7.9.      Centiseconds -> time string
'/* former function name: TimeString() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[11]:swe_cs2timestr()"
PrintDetails "========================="

Dim t As Long                 '// value in Centiseconds
Dim sep As Long               '/* use in former function name: TimeString() */
Dim suppressZero As Long      '/* Flag for Calculation. See user's manual */
Dim a As String               '//TimeString of Size 256
a = Space$(256)               '//TimeString of Size 256
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

t = 10.555 * 360000 '10.555 hours in CentiSecs
sep = Asc(":")
suppressZero = 1

lpCHARA = swe_cs2timestr_LPCHARA(t, sep, suppressZero, a)

PrintDetails "t=", t
PrintDetails "sep=", sep
PrintDetails "suppressZero=", suppressZero
'PrintDetails "lpCHARA=", lpCHARA
sRetText = GetStrFromLPCHARA(lpCHARA)
PrintDetails "sRetText =", sRetText
PrintDetails "a=", TrimNullChar(a)

End Sub 'Test11()

Public Sub Test12()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  991]:     ext_def(centisec) swe_csnorm(centisec p);
'18.7.1.      Normalize argument into interval [0..DEG360]
'/ * former function name: csnorm() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[12]:swe_csnorm()"
PrintDetails "====================="

Dim p As Long                 '//Value in CentiSeconds
Dim lRet As Long              'Return value

p = 361 * 360000 '361 degrees in CentiSecs
lRet = swe_csnorm(p)

PrintDetails "p=", p
PrintDetails "lRet=", lRet

End Sub 'Test12()

Public Sub Test13()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1005]:     ext_def(centisec) swe_csroundsec(centisec x);
'18.7.6.      Round second, but at 29.5959 always down
'/* former function name: roundsec() */
'centisec swe_csroundsec(centisec x);
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[13]:swe_csroundsec()"
PrintDetails "========================="

Dim x As Long                 '//CentiSeconds
Dim lRet As Long              'Return value

x = (1.5 + 29.5959 / 3600) * 360000 '1:30:29.5959 degrees in CentiSecs

lRet = swe_csroundsec(x)

PrintDetails "x=", x
PrintDetails "lRet=", lRet

End Sub 'Test13()

Public Sub Test14()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1008]:     ext_def(int32) swe_d2l(double x);
'18.7.7.      Double to long with rounding, no overflow check
'/* former function name: d2l() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=================="
PrintDetails "Test[14]:swe_d2l()"
PrintDetails "=================="

Dim x As Double               '//double to long with rounding, no overflow check
Dim lRet As Long              'Return value

x = 5429.5959 '(1.5 + 29.5959 / 3600) * 3600 '1:30:29.5959 in degrees

lRet = swe_d2l(x)

PrintDetails "x=", x
PrintDetails "lRet=", lRet

x = 5429.45 '(1.5 + 29.45 / 3600) * 3600 '1:30:29.5959 in degrees

lRet = swe_d2l(x)

PrintDetails "x=", x
PrintDetails "lRet=", lRet

End Sub 'Test14()

Public Sub Test15()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  776]:     ext_def(int) swe_date_conversion(int y , int m , int d , double utime, char c, double *tjd);
'9.1.  Calendar date and Julian day: swe_date_conversion()
'These functions are needed to convert calendar dates to the astronomical time scale which measures time in Julian days.
'compute a Julian day number from year, month, day, and hour and checks in addition
'whether the date is legal. It returns OK or ERR.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[15]:swe_date_conversion()"
PrintDetails "=============================="

Dim y As Long                 '//Year of the date
Dim m As Long                 '//Month of the date
Dim d As Long                 '//Day in the date
Dim utime As Double           '/* hours (decimal, with fraction) */
Dim c As Byte                 '/* calendar g[regorian] | j[ulian] */
Dim tjd As Double             '//Julian Day Number
Dim lRet As Long              'Return value

y = 2021
m = 10
d = 1
utime = 11.5
c = SE_GREG_CAL

lRet = swe_date_conversion(y, m, d, utime, c, tjd)

PrintDetails "y=", y
PrintDetails "m=", m
PrintDetails "d=", d
PrintDetails "utime=", utime
PrintDetails "c=", c
PrintDetails "tjd=", tjd
PrintDetails "lRet=", lRet
If lRet = 0 Then PrintDetails "Valid Date" Else PrintDetails "inValid Date"

y = 2021
m = 2
d = 29
utime = 11.5
c = SE_GREG_CAL

lRet = swe_date_conversion(y, m, d, utime, c, tjd)

PrintDetails "y=", y
PrintDetails "m=", m
PrintDetails "d=", d
PrintDetails "utime=", utime
PrintDetails "c=", c
PrintDetails "tjd=", tjd
PrintDetails "lRet=", lRet
If lRet = -1 Then PrintDetails "inValid Date" Else PrintDetails "Valid Date"

End Sub 'Test15()

Public Sub Test16()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1011]:     ext_def(int) swe_day_of_week(double jd);
'18.7.8.      Day of week Monday = 0, ... Sunday = 6
'/* former function name: day_of_week() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[16]:swe_day_of_week()"
PrintDetails "=========================="

Dim jd As Double              '//Julian day Number
Dim lRet As Long              'Return value

Dim vWeek As Variant
vWeek = Array("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday")

jd = swe_julday(2021, 10, 1, 11.5, SE_GREG_CAL)

lRet = swe_day_of_week(jd)

PrintDetails "jd=", jd
PrintDetails "lRet=", lRet
PrintDetails "WeekDay=", vWeek(lRet)

End Sub 'Test16()

Public Sub Test17()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  980]:     ext_def(double) swe_deg_midp(double x1, double x0);
'***********************(obsolete/Internal use)*******************
'/* finds midpoint of the arc from x0 to x1 range 0 ... 180*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[17]:swe_deg_midp()"
PrintDetails "======================="

Dim x1 As Double              '//Value in Degree
Dim x0 As Double              '//Value in Degree
Dim dret As Double            'Return value

x0 = 10#
x1 = 170#

dret = swe_deg_midp(x1, x0)

PrintDetails "x1=", x1
PrintDetails "x0=", x0
PrintDetails "dRet=", dret

End Sub 'Test17()

Public Sub Test18()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  977]:     ext_def(double) swe_degnorm(double x);
'18.6.4.      swe_degnorm(): normalize degrees to the range 0 ... 360
'normalization of any degree number X to the range 0 ... 360
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================"
PrintDetails "Test[18]:swe_degnorm()"
PrintDetails "======================"

Dim x As Double               '//Value in Degree
Dim dret As Double            'Return value

x = 361  '361 degrees

dret = swe_degnorm(x)

PrintDetails "x=", x
PrintDetails "dRet=", dret

End Sub 'Test18()

Public Sub Test19()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  952]:     ext_def(double) swe_deltat(double tjd);
'10.2.      swe_deltat() DeltaT calculation
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[19]:swe_deltat()"
PrintDetails "====================="

Dim tjd As Double             '//Julian day, universal time (UT)
Dim dret As Double            'Return value

tjd = swe_julday(2021, 10, 2, 10, 1)

dret = swe_deltat(tjd)

PrintDetails "tjd=", tjd
PrintDetails "dRet=", dret

End Sub 'Test19()

Public Sub Test20()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  953]:     ext_def(double) swe_deltat_ex(double tjd, int32 iflag, char *serr);
'10.1.      swe_deltat_ex() ephemeris-dependent values of Delta T
'and is therefore better than the old function swe_deltat()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================"
PrintDetails "Test[20]:swe_deltat_ex()"
PrintDetails "========================"

Dim tjd As Double             '//Julian Day Number
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

tjd = swe_julday(2021, 10, 2, 10, 1)
iflag = SEFLG_SWIEPH 'SEFLG_JPLEPH 'SEFLG_MOSEPH

dret = swe_deltat_ex(tjd, iflag, serr)

PrintDetails "tjd=", tjd
PrintDetails "iflag=", iflag
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test20()

Public Sub Test21()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  999]:     ext_def(centisec) swe_difcs2n(centisec p1, centisec p2);
'18.7.4.Distance in centisecs p1 - p2 normalized to [-180..180]
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================"
PrintDetails "Test[21]:swe_difcs2n()"
PrintDetails "======================"

Dim p1 As Long                '//Distance in centisecs
Dim p2 As Long                '//Distance in centisecs
Dim lRet As Long              'Return value

p1 = 10 * 360000
p2 = 1 * 360000

lRet = swe_difcs2n(p1, p2)

PrintDetails "p1=", p1
PrintDetails "p2=", p2
PrintDetails "lRet=", lRet

End Sub 'Test21()

Public Sub Test22()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  994]:     ext_def(centisec) swe_difcsn(centisec p1, centisec p2);
'18.7.2.      Distance in centisecs p1 - p2 normalized to [0..360]
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[22]:swe_difcsn()"
PrintDetails "====================="

Dim p1 As Long                '//Distance in centisecs
Dim p2 As Long                '//Distance in centisecs
Dim lRet As Long              'Return value

p1 = 10 * 360000
p2 = 1 * 360000

lRet = swe_difcsn(p1, p2)

PrintDetails "p1=", p1
PrintDetails "p2=", p2
PrintDetails "lRet=", lRet

End Sub 'Test22()

Public Sub Test23()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1001]:     ext_def(double) swe_difdeg2n(double p1, double p2);
'18.7.5.      Distance in degrees normalized to [0..180]???
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[23]:swe_difdeg2n()"
PrintDetails "======================="

Dim p1 As Double              '// Distance in degrees
Dim p2 As Double              '// Distance in degrees
Dim dret As Double            'Return value

p1 = 185 '* 360000
p2 = 1 '* 360000

dret = swe_difdeg2n(p1, p2)

PrintDetails "p1=", p1
PrintDetails "p2=", p2
PrintDetails "dRet=", dret

End Sub 'Test23()

Public Sub Test24()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  996]:     ext_def(double) swe_difdegn(double p1, double p2);
'18.7.3.      Distance in degrees
'/* finds the difference in degree p1-p2 normilize 0 ...360*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================"
PrintDetails "Test[24]:swe_difdegn()"
PrintDetails "======================"

Dim p1 As Double              '// Distance in degrees
Dim p2 As Double              '// Distance in degrees
Dim dret As Double            'Return value

p1 = 185 '* 360000
p2 = 1 '* 360000

dret = swe_difdegn(p1, p2)

PrintDetails "p1=", p1
PrintDetails "p2=", p2
PrintDetails "dRet=", dret

End Sub 'Test24()

Public Sub Test25()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1002]:     ext_def(double) swe_difrad2n(double p1, double p2);
'***********************(obsolete/Internal use)*******************
'/* finds the difference of arc from p1-p0 normalize to 0 ... pi*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[25]:swe_difrad2n()"
PrintDetails "======================="

Dim p1 As Double              '// Distance in radians
Dim p2 As Double              '// Distance in radians
Dim dret As Double            'Return value

p1 = 4 '* 360000
p2 = 2 '* 360000

dret = swe_difrad2n(p1, p2)

PrintDetails "p1=", p1
PrintDetails "p2=", p2
PrintDetails "dRet=", dret

End Sub 'Test25()

Public Sub Test26()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  732]:     ext_def(int32) swe_fixstar2(char *star, double tjd, int32 iflag,double *xx,char *serr);
'6.1.  Different functions for calculating fixed star positions
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[26]:swe_fixstar2()"
PrintDetails "======================="

Dim star As String            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
star = Space$(256)            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim tjd As Double             '//Julian Day Number, ET/TT
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim xx(6) As Double           '//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
star = "Aldebaran,alTau"
tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd = tjd + swe_deltat(tjd)
iflag = 0

lRet = swe_fixstar2(star, tjd, iflag, xx(0), serr)

PrintDetails "star=", TrimNullChar(star)
PrintDetails "tjd=", tjd
PrintDetails "iflag=", iflag
PrintDetails "xx(0)=", xx(0)
PrintDetails "xx(1)=", xx(1)
PrintDetails "xx(2)=", xx(2)
PrintDetails "xx(3)=", xx(3)
PrintDetails "xx(4)=", xx(4)
PrintDetails "xx(5)=", xx(5)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test26()

Public Sub Test27()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  740]:     ext_def(int32) swe_fixstar2_mag(char *star, double *mag, char *serr);
'6.3.  swe_fixstar2_mag(), swe_fixstar_mag()
'Function calculates the magnitude of a fixed star.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==========================="
PrintDetails "Test[27]:swe_fixstar2_mag()"
PrintDetails "==========================="

Dim star As String            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
star = Space$(256)            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim mag As Double             '//magnitude of a fixed star
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
star = "Aldebaran,alTau"

lRet = swe_fixstar2_mag(star, mag, serr)

PrintDetails "star=", TrimNullChar(star)
PrintDetails "mag=", mag
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test27()

Public Sub Test28()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  737]:     ext_def(int32) swe_fixstar2_ut(char *star, double tjd_ut, int32 iflag, double *xx, char *serr);
'6.2.  swe_fixstar2_ut(), swe_fixstar2(), swe_fixstar_ut(), swe_fixstar()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[28]:swe_fixstar2_ut()"
PrintDetails "=========================="

Dim star As String            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
star = Space$(256)            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim xx(6) As Double           '//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
star = "Aldebaran,alTau"
tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd = tjd + swe_deltat(tjd)
iflag = 0

lRet = swe_fixstar2_ut(star, tjd_ut, iflag, xx(0), serr)

PrintDetails "star=", TrimNullChar(star)
PrintDetails "tjd_ut=", tjd_ut
PrintDetails "iflag=", iflag
PrintDetails "xx(0)=", xx(0)
PrintDetails "xx(1)=", xx(1)
PrintDetails "xx(2)=", xx(2)
PrintDetails "xx(3)=", xx(3)
PrintDetails "xx(4)=", xx(4)
PrintDetails "xx(5)=", xx(5)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test28()

Public Sub Test29()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  722]:     ext_def(int32) swe_fixstar(char *star, double tjd, int32 iflag,double *xx,char *serr);
'6.2.  swe_fixstar2_ut(), swe_fixstar2(), swe_fixstar_ut(), swe_fixstar()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================"
PrintDetails "Test[29]:swe_fixstar()"
PrintDetails "======================"

Dim star As String            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
star = Space$(256)            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim tjd As Double             '//Julian Day Number, ET/TT
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim xx(6) As Double           '//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
star = "Aldebaran,alTau"
tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd = tjd + swe_deltat(tjd)
iflag = 0

lRet = swe_fixstar(star, tjd, iflag, xx(0), serr)

PrintDetails "star=", TrimNullChar(star)
PrintDetails "tjd=", tjd
PrintDetails "iflag=", iflag
PrintDetails "xx(0)=", xx(0)
PrintDetails "xx(1)=", xx(1)
PrintDetails "xx(2)=", xx(2)
PrintDetails "xx(3)=", xx(3)
PrintDetails "xx(4)=", xx(4)
PrintDetails "xx(5)=", xx(5)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test29()

Public Sub Test30()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  730]:     ext_def(int32) swe_fixstar_mag(char *star, double *mag, char *serr);
'6.3.  swe_fixstar2_mag(), swe_fixstar_mag()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[30]:swe_fixstar_mag()"
PrintDetails "=========================="

Dim star As String            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
star = Space$(256)            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim mag As Double             '//magnitude of a fixed star
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
star = "Aldebaran,alTau"

lRet = swe_fixstar_mag(star, mag, serr)

PrintDetails "star=", TrimNullChar(star)
PrintDetails "mag=", mag
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test30()

Public Sub Test31()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  727]:     ext_def(int32) swe_fixstar_ut(char *star, double tjd_ut, int32 iflag, double *xx, char *serr);
'6.         Fixed stars functions
'6.2.  swe_fixstar2_ut(), swe_fixstar2(), swe_fixstar_ut(), swe_fixstar()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[31]:swe_fixstar_ut()"
PrintDetails "========================="

Dim star As String            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
star = Space$(256)            '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim xx(6) As Double           '//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
star = "Aldebaran,alTau"
tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd = tjd + swe_deltat(tjd)
iflag = 0

lRet = swe_fixstar_ut(star, tjd_ut, iflag, xx(0), serr)

PrintDetails "star=", TrimNullChar(star)
PrintDetails "tjd_ut=", tjd_ut
PrintDetails "iflag=", iflag
PrintDetails "xx(0)=", xx(0)
PrintDetails "xx(1)=", xx(1)
PrintDetails "xx(2)=", xx(2)
PrintDetails "xx(3)=", xx(3)
PrintDetails "xx(4)=", xx(4)
PrintDetails "xx(5)=", xx(5)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test31()

Public Sub Test32()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  848]:     ext_def(int32) swe_gauquelin_sector(double t_ut, int32 ipl, char *starname, int32 iflag, int32 imeth, double *geopos, double atpress, double attemp, double *dgsect, char *serr);
'16.1.      Calculating the Gauquelin sector position of a planet with swe_house_pos() or swe_gauquelin_sector()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==============================="
PrintDetails "Test[32]:swe_gauquelin_sector()"
PrintDetails "==============================="

Dim t_ut As Double            '/* input time JulianDay Number (UT) */
Dim ipl As Long               '//fixed set of body numbers
Dim starname As String        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
starname = Space$(256)        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim imeth As Long             '/* method flag for Calculation*/
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim atpress As Double         '/* atmospheric pressure in mbar/hPa */
Dim attemp As Double          '// atmospheric temperature in degrees Celsius
Dim dgsect As Double          '/* return address for Gauquelin sector position */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
ipl = 0
t_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd = tjd + swe_deltat(tjd)
iflag = 0
starname = "Aldebaran,alTau"

lRet = swe_gauquelin_sector(t_ut, ipl, starname, iflag, imeth, geopos(0), atpress, attemp, dgsect, serr)

PrintDetails "t_ut=", t_ut
PrintDetails "ipl=", ipl
PrintDetails "starname=", TrimNullChar(starname)
PrintDetails "iflag=", iflag
PrintDetails "imeth=", imeth
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "dgsect=", dgsect
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test32()

Public Sub Test33()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  692]:     ext_def(void) swe_get_astro_models(char *samod, char *sdet, int32 iflag);
'***********************(obsolete/Internal use)*******************
'*WARNING:/* This function is for inhouse testing only */*******
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==============================="
PrintDetails "Test[33]:swe_get_astro_models()"
PrintDetails "==============================="

Dim samod As String           '//Model Name Internal use only
samod = Space$(256)           '//Model Name Internal use only
Dim sdet As String            '//String to hold internal use only
sdet = Space$(256)            '//String to hold internal use only
Dim iflag As Long             '//Control Flag for internal use only

Call swe_get_astro_models(samod, sdet, iflag)

PrintDetails "samod=", TrimNullChar(samod)
PrintDetails "sdet=", TrimNullChar(sdet)
PrintDetails "iflag=", iflag

PrintDetails "*WARNING:/* This function is for inhouse testing only */*******"

End Sub 'Test33()

Public Sub Test34()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  763]:     ext_def(double) swe_get_ayanamsa(double tjd_et);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha without nutation
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==========================="
PrintDetails "Test[34]:swe_get_ayanamsa()"
PrintDetails "==========================="

Dim tjd_et As Double          '//julian Day Number in ET/TT
Dim dret As Double            'Return value

Call swe_set_sid_mode(SE_SIDM_KRISHNAMURTI_VP291, 0, 0)
tjd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd_et = tjd_et + swe_deltat(tjd_et)

dret = swe_get_ayanamsa(tjd_et)

PrintDetails "tjd_et=", tjd_et
PrintDetails "dRet=", dret

End Sub 'Test34()

Public Sub Test35()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  761]:     ext_def(int32) swe_get_ayanamsa_ex(double tjd_et, int32 iflag, double *daya, char *serr);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha with or without nutation depending on the parameter iflag.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[35]:swe_get_ayanamsa_ex()"
PrintDetails "=============================="

Dim tjd_et As Double          '//julian Day Number in ET/TT
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim daya As Double            '/* output: ayanamsha value (pointer to double) */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_sid_mode(SE_SIDM_KRISHNAMURTI_VP291, 0, 0)
tjd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd_et = tjd_et + swe_deltat(tjd_et)
iflag = SEFLG_NONUT

lRet = swe_get_ayanamsa_ex(tjd_et, iflag, daya, serr)

PrintDetails "tjd_et=", tjd_et
PrintDetails "iflag=", iflag
PrintDetails "daya=", daya
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test35()

Public Sub Test36()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  762]:     ext_def(int32) swe_get_ayanamsa_ex_ut(double tjd_ut, int32 iflag, double *daya, char *serr);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha with or without nutation depending on the parameter iflag.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "================================="
PrintDetails "Test[36]:swe_get_ayanamsa_ex_ut()"
PrintDetails "================================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim daya As Double            '/* output: ayanamsha value (pointer to double) */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_sid_mode(SE_SIDM_KRISHNAMURTI_VP291, 0, 0)
tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_et = tjd_ut + swe_deltat(tjd_ut)
iflag = SEFLG_NONUT

lRet = swe_get_ayanamsa_ex_ut(tjd_ut, iflag, daya, serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "iflag=", iflag
PrintDetails "daya=", daya
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test36()

Public Sub Test37()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  767]:     ext_def(const char *) swe_get_ayanamsa_name(int32 isidmode);
' 18.1.4.      Set the sidereal mode and get ayanamsha values
' find the name of an ayanamsha
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "================================"
PrintDetails "Test[37]:swe_get_ayanamsa_name()"
PrintDetails "================================"

Dim isidmode As Long          '//Ayanamsa Number
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

'isidmode = SE_SIDM_KRISHNAMURTI_VP291'45
For isidmode = 0 To 46
    lpCHARA = swe_get_ayanamsa_name_LPCHARA(isidmode)
    PrintDetails "isidmode=", isidmode
    'PrintDetails "lpCHARA=", lpCHARA
    sRetText = GetStrFromLPCHARA(lpCHARA)
    PrintDetails "sRetText =", sRetText
Next
End Sub 'Test37()

Public Sub Test38()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  764]:     ext_def(double) swe_get_ayanamsa_ut(double tjd_ut);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha without nutation.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[38]:swe_get_ayanamsa_ut()"
PrintDetails "=============================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim dret As Double            'Return value

Call swe_set_sid_mode(SE_SIDM_KRISHNAMURTI_VP291, 0, 0)

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_et = tjd_ut + swe_deltat(tjd_ut)

dret = swe_get_ayanamsa_ut(tjd_ut)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "dRet=", dret

End Sub 'Test38()

Public Sub Test39()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  768]:     ext_def(const char *) swe_get_current_file_data(int ifno, double *tfstart, double *tfend, int *denum);
'2.6.  swe_get_current_file_data()
'This is function can be used to find out the start and end date of an *se1 ephemeris file after a call of swe_calc().
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "===================================="
PrintDetails "Test[39]:swe_get_current_file_data()"
PrintDetails "===================================="

Dim ifno As Long              '//File Number flag (0 to 4)
Dim tfstart As Double         '// start date of file,
Dim tfend As Double           '//end data of file,
Dim denum As Long             '// denum   = jpl ephemeris number 406 or 431 from which file was derived
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
ifno = 0
lpCHARA = swe_get_current_file_data_LPCHARA(ifno, tfstart, tfend, denum)

PrintDetails "ifno=", ifno
PrintDetails "tfstart=", tfstart
PrintDetails "tfend=", tfend
PrintDetails "denum=", denum
'PrintDetails "lpCHARA=", lpCHARA
sRetText = GetStrFromLPCHARA(lpCHARA)
PrintDetails "sRetText =", sRetText

End Sub 'Test39()

Public Sub Test40()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  699]:     ext_def(char *) swe_get_library_path(char *);
'2.5.  swe_get_library_path()
'/* find out the library path of the DLL or executable */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==============================="
PrintDetails "Test[40]:swe_get_library_path()"
PrintDetails "==============================="

Dim s As String               '//Return String  must be able to hold 256 bytes
s = Space$(256)               '//Return String  must be able to hold 256 bytes
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
'Call swe_set_jpl_file(SE_FNAME_DE406)

lpCHARA = swe_get_library_path_LPCHARA(s)

PrintDetails "s=", TrimNullChar(s)
'PrintDetails "lpCHARA=", lpCHARA
sRetText = GetStrFromLPCHARA(lpCHARA)
PrintDetails "sRetText =", sRetText

End Sub 'Test40()

Public Sub Test41()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  942]:     ext_def(int32) swe_get_orbital_elements(double tjd_et, int32 ipl, int32 iflag, double *dret, char *serr);
'7.2.  swe_get_orbital_elements() (Kepler elements and orbital data)
'This function calculates osculating elements (Kepler elements) and
'orbital periods for a planet, the Earth-Moon barycenter, or an asteroid.
'The elements are calculated relative to the mean ecliptic J2000.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==================================="
PrintDetails "Test[41]:swe_get_orbital_elements()"
PrintDetails "==================================="

Dim tjd_et As Double          '//julian Day Number in ET/TT
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim dret(50) As Double        '/* result: Return array, See User's manual */Declare array of 50 doubles
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
'Call swe_set_jpl_file(SE_FNAME_DE406)
tjd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd_et = tjd_et + swe_deltat(tjd_et)

For ipl = 1 To 9

    lRet = swe_get_orbital_elements(tjd_et, ipl, iflag, dret(0), serr)
    
    PrintDetails "tjd_et=", tjd_et
    PrintDetails "ipl=", ipl
    PrintDetails "iflag=", iflag
    PrintDetails "dret(0)=", dret(0)
    PrintDetails "dret(1)=", dret(1)
    PrintDetails "dret(2)=", dret(2)
    PrintDetails "dret(3)=", dret(3)
    PrintDetails "dret(4)=", dret(4)
    PrintDetails "dret(5)=", dret(5)
    PrintDetails "dret(6)=", dret(6)
    PrintDetails "dret(7)=", dret(7)
    PrintDetails "dret(8)=", dret(8)
    PrintDetails "dret(9)=", dret(9)
    PrintDetails "dret(10)=", dret(10)
    PrintDetails "dret(11)=", dret(11)
    PrintDetails "dret(12)=", dret(12)
    PrintDetails "dret(13)=", dret(13)
    PrintDetails "dret(14)=", dret(14)
    PrintDetails "dret(15)=", dret(15)
    PrintDetails "dret(16)=", dret(16)
    PrintDetails "dret(17)=", dret(17)
    PrintDetails "dret(18)=", dret(18)
    PrintDetails "dret(19)=", dret(19)
    PrintDetails "dret(20)=", dret(20)
    PrintDetails "dret(21)=", dret(21)
    PrintDetails "dret(22)=", dret(22)
    PrintDetails "dret(23)=", dret(23)
    PrintDetails "dret(24)=", dret(24)
    PrintDetails "dret(25)=", dret(25)
    PrintDetails "dret(26)=", dret(26)
    PrintDetails "dret(27)=", dret(27)
    PrintDetails "dret(28)=", dret(28)
    PrintDetails "dret(29)=", dret(29)
    PrintDetails "dret(30)=", dret(30)
    PrintDetails "dret(31)=", dret(31)
    PrintDetails "dret(32)=", dret(32)
    PrintDetails "dret(33)=", dret(33)
    PrintDetails "dret(34)=", dret(34)
    PrintDetails "dret(35)=", dret(35)
    PrintDetails "dret(36)=", dret(36)
    PrintDetails "dret(37)=", dret(37)
    PrintDetails "dret(38)=", dret(38)
    PrintDetails "dret(39)=", dret(39)
    PrintDetails "dret(40)=", dret(40)
    PrintDetails "dret(41)=", dret(41)
    PrintDetails "dret(42)=", dret(42)
    PrintDetails "dret(43)=", dret(43)
    PrintDetails "dret(44)=", dret(44)
    PrintDetails "dret(45)=", dret(45)
    PrintDetails "dret(46)=", dret(46)
    PrintDetails "dret(47)=", dret(47)
    PrintDetails "dret(48)=", dret(48)
    PrintDetails "dret(49)=", dret(49)
    PrintDetails "serr=", TrimNullChar(serr)
    PrintDetails "lRet=", lRet
Next

End Sub 'Test41()


Public Sub Test42()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  752]:     ext_def(char *) swe_get_planet_name(int ipl, char *spname);
'5.         The function swe_get_planet_name()
'This function allows to find a planetary or asteroid name,
'when the planet number is given. The function definition is:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[42]:swe_get_planet_name()"
PrintDetails "=============================="

Dim ipl As Long               '//fixed set of body numbers
Dim spname As String          '//Return Planet Name  must be able to hold 256 bytes
spname = Space$(256)          '//Return Planet Name  must be able to hold 256 bytes
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

For ipl = 0 To 11
    spname = Space$(256)           '//Return Planet Name  must be able to hold 256 bytes
    lpCHARA = swe_get_planet_name_LPCHARA(ipl, spname)
    PrintDetails "ipl=", ipl
    'PrintDetails "lpCHARA=", lpCHARA
    sRetText = GetStrFromLPCHARA(lpCHARA)
    PrintDetails "spname=", TrimNullChar(spname)
    PrintDetails "sRetText =", sRetText
Next

End Sub 'Test42()

Public Sub Test43()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  970]:     ext_def(double) swe_get_tid_acc(void);
'18.3.9.      Get tidal acceleration used in swe_deltat()
'/* returns tidal acceleration used in swe_deltat() and swe_deltat_ex() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[43]:swe_get_tid_acc()"
PrintDetails "=========================="

Dim dret As Double            'Return value

dret = swe_get_tid_acc()

PrintDetails "dRet=", dret

End Sub 'Test43()

Public Sub Test44()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  686]:     ext_def(int32) swe_heliacal_angle(double tjdut, double *dgeo, double *datm, double *dobs, int32 helflag, double mag, double azi_obj, double azi_sun, double azi_moon, double alt_moon, double *dret, char *serr);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "============================="
PrintDetails "Test[44]:swe_heliacal_angle()"
PrintDetails "============================="

Dim tjdut As Double           '//Julian day, universal time (UT)
Dim dgeo(3) As Double         '/* geographic position (details User's manual) */declare array of 3 doubles
Dim datm(10) As Double        '/* atmospheric conditions (details User's manual) */declare array of 10 doubles
Dim dobs(10) As Double        '/* observer description (details User's manual) */declare array of 10 doubles
Dim helflag As Long           '/* Flag for Calculation. See user's manual */
Dim mag As Double             '//For internal use
Dim azi_obj As Double         '//For internal use
Dim azi_sun As Double         '//For internal use
Dim azi_moon As Double        '//For internal use
Dim alt_moon As Double        '//For internal use
Dim dret(50) As Double        '/* result: Return array, See User's manual */Declare array of 50 doubles
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjdut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
dgeo(0) = 80# 'geograph. longitude, +Ve east
dgeo(1) = 13# 'geograph. latitude +Ve north
dgeo(2) = 0# 'geograph. height

lRet = swe_heliacal_angle(tjdut, dgeo(0), datm(0), dobs(0), helflag, mag, azi_obj, azi_sun, azi_moon, alt_moon, dret(0), serr)

PrintDetails "tjdut=", tjdut
PrintDetails "dgeo(0)=", dgeo(0)
PrintDetails "dgeo(1)=", dgeo(1)
PrintDetails "dgeo(2)=", dgeo(2)
PrintDetails "datm(0)=", datm(0)
PrintDetails "datm(1)=", datm(1)
PrintDetails "datm(2)=", datm(2)
PrintDetails "datm(3)=", datm(3)
PrintDetails "datm(4)=", datm(4)
PrintDetails "datm(5)=", datm(5)
PrintDetails "datm(6)=", datm(6)
PrintDetails "datm(7)=", datm(7)
PrintDetails "datm(8)=", datm(8)
PrintDetails "datm(9)=", datm(9)
PrintDetails "dobs(0)=", dobs(0)
PrintDetails "dobs(1)=", dobs(1)
PrintDetails "dobs(2)=", dobs(2)
PrintDetails "dobs(3)=", dobs(3)
PrintDetails "dobs(4)=", dobs(4)
PrintDetails "dobs(5)=", dobs(5)
PrintDetails "dobs(6)=", dobs(6)
PrintDetails "dobs(7)=", dobs(7)
PrintDetails "dobs(8)=", dobs(8)
PrintDetails "dobs(9)=", dobs(9)
PrintDetails "helflag=", helflag
PrintDetails "mag=", mag
PrintDetails "azi_obj=", azi_obj
PrintDetails "azi_sun=", azi_sun
PrintDetails "azi_moon=", azi_moon
PrintDetails "alt_moon=", alt_moon
PrintDetails "dret(0)=", dret(0)
PrintDetails "dret(1)=", dret(1)
PrintDetails "dret(2)=", dret(2)
PrintDetails "dret(3)=", dret(3)
PrintDetails "dret(4)=", dret(4)
PrintDetails "dret(5)=", dret(5)
PrintDetails "dret(6)=", dret(6)
PrintDetails "dret(7)=", dret(7)
PrintDetails "dret(8)=", dret(8)
PrintDetails "dret(9)=", dret(9)
PrintDetails "dret(10)=", dret(10)
PrintDetails "dret(11)=", dret(11)
PrintDetails "dret(12)=", dret(12)
PrintDetails "dret(13)=", dret(13)
PrintDetails "dret(14)=", dret(14)
PrintDetails "dret(15)=", dret(15)
PrintDetails "dret(16)=", dret(16)
PrintDetails "dret(17)=", dret(17)
PrintDetails "dret(18)=", dret(18)
PrintDetails "dret(19)=", dret(19)
PrintDetails "dret(20)=", dret(20)
PrintDetails "dret(21)=", dret(21)
PrintDetails "dret(22)=", dret(22)
PrintDetails "dret(23)=", dret(23)
PrintDetails "dret(24)=", dret(24)
PrintDetails "dret(25)=", dret(25)
PrintDetails "dret(26)=", dret(26)
PrintDetails "dret(27)=", dret(27)
PrintDetails "dret(28)=", dret(28)
PrintDetails "dret(29)=", dret(29)
PrintDetails "dret(30)=", dret(30)
PrintDetails "dret(31)=", dret(31)
PrintDetails "dret(32)=", dret(32)
PrintDetails "dret(33)=", dret(33)
PrintDetails "dret(34)=", dret(34)
PrintDetails "dret(35)=", dret(35)
PrintDetails "dret(36)=", dret(36)
PrintDetails "dret(37)=", dret(37)
PrintDetails "dret(38)=", dret(38)
PrintDetails "dret(39)=", dret(39)
PrintDetails "dret(40)=", dret(40)
PrintDetails "dret(41)=", dret(41)
PrintDetails "dret(42)=", dret(42)
PrintDetails "dret(43)=", dret(43)
PrintDetails "dret(44)=", dret(44)
PrintDetails "dret(45)=", dret(45)
PrintDetails "dret(46)=", dret(46)
PrintDetails "dret(47)=", dret(47)
PrintDetails "dret(48)=", dret(48)
PrintDetails "dret(49)=", dret(49)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

PrintDetails "WARNING:This function is obsolete/Internal use*******************"

End Sub 'Test44()

Public Sub Test45()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  682]:     ext_def(int32) swe_heliacal_pheno_ut(double tjd_ut, double *geopos, double *datm, double *dobs, char *ObjectName, int32 TypeEvent, int32 helflag, double *darr, char *serr);
'***********************<>*******************
'8.19.      Heliacal details: swe_heliacal_pheno_ut()
'provides data that are relevant for the calculation of heliacal risings and settings.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "================================"
PrintDetails "Test[45]:swe_heliacal_pheno_ut()"
PrintDetails "================================"

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim datm(10) As Double        '/* atmospheric conditions (details User's manual) */declare array of 10 doubles
Dim dobs(10) As Double        '/* observer description (details User's manual) */declare array of 10 doubles
Dim ObjectName As String      '/* name string of fixed star or planet */ Name Size 40 Chars?
ObjectName = Space$(256)      '/* name string of fixed star or planet */ Name Size 40 Chars?
Dim TypeEvent As Long         '/* event type */
Dim helflag As Long           '/* Flag for Calculation. See user's manual */
Dim darr(50) As Double        '/* return array, declare array of 50 doubles */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
geopos(0) = 80# 'geograph. longitude, +Ve east
geopos(1) = 13# 'geograph. latitude +Ve north
geopos(2) = 0# 'geograph. height
ObjectName = "moon"

lRet = swe_heliacal_pheno_ut(tjd_ut, geopos(0), datm(0), dobs(0), ObjectName, TypeEvent, helflag, darr(0), serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "datm(0)=", datm(0)
PrintDetails "datm(1)=", datm(1)
PrintDetails "datm(2)=", datm(2)
PrintDetails "datm(3)=", datm(3)
PrintDetails "datm(4)=", datm(4)
PrintDetails "datm(5)=", datm(5)
PrintDetails "datm(6)=", datm(6)
PrintDetails "datm(7)=", datm(7)
PrintDetails "datm(8)=", datm(8)
PrintDetails "datm(9)=", datm(9)
PrintDetails "dobs(0)=", dobs(0)
PrintDetails "dobs(1)=", dobs(1)
PrintDetails "dobs(2)=", dobs(2)
PrintDetails "dobs(3)=", dobs(3)
PrintDetails "dobs(4)=", dobs(4)
PrintDetails "dobs(5)=", dobs(5)
PrintDetails "dobs(6)=", dobs(6)
PrintDetails "dobs(7)=", dobs(7)
PrintDetails "dobs(8)=", dobs(8)
PrintDetails "dobs(9)=", dobs(9)
PrintDetails "ObjectName=", TrimNullChar(ObjectName)
PrintDetails "TypeEvent=", TypeEvent
PrintDetails "helflag=", helflag
PrintDetails "darr(0)=", darr(0)
PrintDetails "darr(1)=", darr(1)
PrintDetails "darr(2)=", darr(2)
PrintDetails "darr(3)=", darr(3)
PrintDetails "darr(4)=", darr(4)
PrintDetails "darr(5)=", darr(5)
PrintDetails "darr(6)=", darr(6)
PrintDetails "darr(7)=", darr(7)
PrintDetails "darr(8)=", darr(8)
PrintDetails "darr(9)=", darr(9)
PrintDetails "darr(10)=", darr(10)
PrintDetails "darr(11)=", darr(11)
PrintDetails "darr(12)=", darr(12)
PrintDetails "darr(13)=", darr(13)
PrintDetails "darr(14)=", darr(14)
PrintDetails "darr(15)=", darr(15)
PrintDetails "darr(16)=", darr(16)
PrintDetails "darr(17)=", darr(17)
PrintDetails "darr(18)=", darr(18)
PrintDetails "darr(19)=", darr(19)
PrintDetails "darr(20)=", darr(20)
PrintDetails "darr(21)=", darr(21)
PrintDetails "darr(22)=", darr(22)
PrintDetails "darr(23)=", darr(23)
PrintDetails "darr(24)=", darr(24)
PrintDetails "darr(25)=", darr(25)
PrintDetails "darr(26)=", darr(26)
PrintDetails "darr(27)=", darr(27)
PrintDetails "darr(28)=", darr(28)
PrintDetails "darr(29)=", darr(29)
PrintDetails "darr(30)=", darr(30)
PrintDetails "darr(31)=", darr(31)
PrintDetails "darr(32)=", darr(32)
PrintDetails "darr(33)=", darr(33)
PrintDetails "darr(34)=", darr(34)
PrintDetails "darr(35)=", darr(35)
PrintDetails "darr(36)=", darr(36)
PrintDetails "darr(37)=", darr(37)
PrintDetails "darr(38)=", darr(38)
PrintDetails "darr(39)=", darr(39)
PrintDetails "darr(40)=", darr(40)
PrintDetails "darr(41)=", darr(41)
PrintDetails "darr(42)=", darr(42)
PrintDetails "darr(43)=", darr(43)
PrintDetails "darr(44)=", darr(44)
PrintDetails "darr(45)=", darr(45)
PrintDetails "darr(46)=", darr(46)
PrintDetails "darr(47)=", darr(47)
PrintDetails "darr(48)=", darr(48)
PrintDetails "darr(49)=", darr(49)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test45()


Public Sub Test46()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  681]:     ext_def(int32) swe_heliacal_ut(double tjdstart_ut, double *geopos, double *datm, double *dobs, char *ObjectName, int32 TypeEvent, int32 iflag, double *dret, char *serr);
'8.17.      Heliacal risings etc.: swe_heliacal_ut()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[46]:swe_heliacal_ut()"
PrintDetails "=========================="

Dim tjdstart_ut As Double     '//Julian day, universal time (UT)
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim datm(10) As Double        '/* atmospheric conditions (details User's manual) */declare array of 10 doubles
Dim dobs(10) As Double        '/* observer description (details User's manual) */declare array of 10 doubles
Dim ObjectName As String      '/* name string of fixed star or planet */ Name Size 40 Chars?
ObjectName = Space$(256)      '/* name string of fixed star or planet */ Name Size 40 Chars?
Dim TypeEvent As Long         '/* event type */
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim dret(50) As Double        '/* result: Return array, See User's manual */Declare array of 50 doubles
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

Call swe_set_ephe_path(sSWEPH_EPHE_PATH)

tjdstart_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
geopos(0) = 80# 'geograph. longitude, +Ve east
geopos(1) = 13# 'geograph. latitude +Ve north
geopos(2) = 0# 'geograph. height

ObjectName = "venus" '"mercury" '"jupiter" '"saturn" 'mars"

lRet = swe_heliacal_ut(tjdstart_ut, geopos(0), datm(0), dobs(0), ObjectName, TypeEvent, iflag, dret(0), serr)

PrintDetails "tjdstart_ut=", tjdstart_ut
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "datm(0)=", datm(0)
PrintDetails "datm(1)=", datm(1)
PrintDetails "datm(2)=", datm(2)
PrintDetails "datm(3)=", datm(3)
PrintDetails "datm(4)=", datm(4)
PrintDetails "datm(5)=", datm(5)
PrintDetails "datm(6)=", datm(6)
PrintDetails "datm(7)=", datm(7)
PrintDetails "datm(8)=", datm(8)
PrintDetails "datm(9)=", datm(9)
PrintDetails "dobs(0)=", dobs(0)
PrintDetails "dobs(1)=", dobs(1)
PrintDetails "dobs(2)=", dobs(2)
PrintDetails "dobs(3)=", dobs(3)
PrintDetails "dobs(4)=", dobs(4)
PrintDetails "dobs(5)=", dobs(5)
PrintDetails "dobs(6)=", dobs(6)
PrintDetails "dobs(7)=", dobs(7)
PrintDetails "dobs(8)=", dobs(8)
PrintDetails "dobs(9)=", dobs(9)
PrintDetails "ObjectName=", TrimNullChar(ObjectName)
PrintDetails "TypeEvent=", TypeEvent
PrintDetails "iflag=", iflag
PrintDetails "dret(0)=", dret(0)
PrintDetails "dret(1)=", dret(1)
PrintDetails "dret(2)=", dret(2)
PrintDetails "dret(3)=", dret(3)
PrintDetails "dret(4)=", dret(4)
PrintDetails "dret(5)=", dret(5)
PrintDetails "dret(6)=", dret(6)
PrintDetails "dret(7)=", dret(7)
PrintDetails "dret(8)=", dret(8)
PrintDetails "dret(9)=", dret(9)
PrintDetails "dret(10)=", dret(10)
PrintDetails "dret(11)=", dret(11)
PrintDetails "dret(12)=", dret(12)
PrintDetails "dret(13)=", dret(13)
PrintDetails "dret(14)=", dret(14)
PrintDetails "dret(15)=", dret(15)
PrintDetails "dret(16)=", dret(16)
PrintDetails "dret(17)=", dret(17)
PrintDetails "dret(18)=", dret(18)
PrintDetails "dret(19)=", dret(19)
PrintDetails "dret(20)=", dret(20)
PrintDetails "dret(21)=", dret(21)
PrintDetails "dret(22)=", dret(22)
PrintDetails "dret(23)=", dret(23)
PrintDetails "dret(24)=", dret(24)
PrintDetails "dret(25)=", dret(25)
PrintDetails "dret(26)=", dret(26)
PrintDetails "dret(27)=", dret(27)
PrintDetails "dret(28)=", dret(28)
PrintDetails "dret(29)=", dret(29)
PrintDetails "dret(30)=", dret(30)
PrintDetails "dret(31)=", dret(31)
PrintDetails "dret(32)=", dret(32)
PrintDetails "dret(33)=", dret(33)
PrintDetails "dret(34)=", dret(34)
PrintDetails "dret(35)=", dret(35)
PrintDetails "dret(36)=", dret(36)
PrintDetails "dret(37)=", dret(37)
PrintDetails "dret(38)=", dret(38)
PrintDetails "dret(39)=", dret(39)
PrintDetails "dret(40)=", dret(40)
PrintDetails "dret(41)=", dret(41)
PrintDetails "dret(42)=", dret(42)
PrintDetails "dret(43)=", dret(43)
PrintDetails "dret(44)=", dret(44)
PrintDetails "dret(45)=", dret(45)
PrintDetails "dret(46)=", dret(46)
PrintDetails "dret(47)=", dret(47)
PrintDetails "dret(48)=", dret(48)
PrintDetails "dret(49)=", dret(49)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test46()


Public Sub Test47()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  718]:     ext_def(int32) swe_helio_cross(int32 ipl, double x2cross, double jd_et, int32 iflag, int32 dir, double *jd_cross, char *serr);
'29.3.      Changes from version 2.10.01 to 2.10.02
'to find crossings of planets over fixed positions:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[47]:swe_helio_cross()"
PrintDetails "=========================="

Dim ipl As Long               '//fixed set of body numbers
Dim x2cross As Double         '//heliocentric crossings over a position x2cross
Dim jd_et As Double           '//Julian day, Ephemeris time/TT
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim dir As Long               '//dir >= 0 indicates search forward in time, dir < 0 indicates search backward in time. It is recommended to use dir = 1 or dir = -1.
Dim jd_cross As Double        '//Julianday Number
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

ipl = 2
x2cross = 10
jd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
jd_et = jd_et + swe_deltat(jd_et)
iflag = 0
dir = 0
lRet = swe_helio_cross(ipl, x2cross, jd_et, iflag, dir, jd_cross, serr)

PrintDetails "ipl=", ipl
PrintDetails "x2cross=", x2cross
PrintDetails "jd_et=", jd_et
PrintDetails "iflag=", iflag
PrintDetails "dir=", dir
PrintDetails "jd_cross=", jd_cross
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test47()

Public Sub Test48()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  719]:     ext_def(int32) swe_helio_cross_ut(int32 ipl, double x2cross, double jd_ut, int32 iflag, int32 dir, double *jd_cross, char *serr);
'4.         Functions to find crossings of planets over positions
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "============================="
PrintDetails "Test[48]:swe_helio_cross_ut()"
PrintDetails "============================="

Dim ipl As Long               '//fixed set of body numbers
Dim x2cross As Double         '//heliocentric crossings over a position x2cross
Dim jd_ut As Double           '//Julian day, universal time (UT)
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim dir As Long               '//dir >= 0 indicates search forward in time, dir < 0 indicates search backward in time. It is recommended to use dir = 1 or dir = -1.
Dim jd_cross As Double        '//Julianday Number
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

ipl = 2
x2cross = 10
jd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'jd_et = jd_et + swe_deltat(jd_et)
iflag = 0
dir = 0
lRet = swe_helio_cross_ut(ipl, x2cross, jd_ut, iflag, dir, jd_cross, serr)

PrintDetails "ipl=", ipl
PrintDetails "x2cross=", x2cross
PrintDetails "jd_ut=", jd_ut
PrintDetails "iflag=", iflag
PrintDetails "dir=", dir
PrintDetails "jd_cross=", jd_cross
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test48()


Public Sub Test49()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  840]:     ext_def(char *) swe_house_name(int hsys);
'15.1.      swe_house_name()
'/* returns the name of the house method, maximum 40 chars */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[49]:swe_house_name()"
PrintDetails "========================="

Dim hsys As Long              '//House Division Number
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

hsys = Asc("P")
lpCHARA = swe_house_name_LPCHARA(hsys)

PrintDetails "hsys=", hsys
'PrintDetails "lpCHARA=", lpCHARA
sRetText = GetStrFromLPCHARA(lpCHARA)
PrintDetails "sRetText =", sRetText

End Sub 'Test49()

Public Sub Test50()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  837]:     ext_def(double) swe_house_pos(double armc, double geolat, double eps, int hsys, double *xpin, char *serr);
'16.     House position of a planet: swe_house_pos()
'To compute the house position of a given body for a given ARMC
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================"
PrintDetails "Test[50]:swe_house_pos()"
PrintDetails "========================"

Dim armc As Double            '//right ascension of meridian collie
Dim geolat As Double          '// latitude,northern is positive & southern is negative
Dim eps As Double             '//Obliquity of ecliptic, in Decimal degrees
Dim hsys As Long              '/* house method, ascii code of one of the letters PKORCAEVXHTBG */
Dim xpin(2) As Double         '/* array of 2 doubles: ecl. longitude and latitude of the planet */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

armc = 15#
geolat = 13#
eps = 23.45
hsys = Asc("P")
dret = swe_house_pos(armc, geolat, eps, hsys, xpin(0), serr)

PrintDetails "armc=", armc
PrintDetails "geolat=", geolat
PrintDetails "eps=", eps
PrintDetails "hsys=", hsys
PrintDetails "xpin(0)=", xpin(0)
PrintDetails "xpin(1)=", xpin(1)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test50()


Public Sub Test51()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  817]:     ext_def(int) swe_houses(double tjd_ut, double geolat, double geolon, int hsys, double *cusps, double *ascmc);
'15.2.      swe_houses()
'/* house cusps, ascendant and MC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[51]:swe_houses()"
PrintDetails "====================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim geolat As Double          '// latitude,northern is positive & southern is negative
Dim geolon As Double          '// geographic longitude,East is positive & West is negative
Dim hsys As Long              '/* house method, ascii code of one of the letters PKORCAEVXHTBG */
Dim cusps(13) As Double       '/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
Dim ascmc(10) As Double       '/* array of 10 doubles, explained in Manual*/
Dim lRet As Long              'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_ut = tjd_ut + swe_deltat(tjd_ut)
geolat = 13#
geolon = 80#
hsys = Asc("P")
lRet = swe_houses(tjd_ut, geolat, geolon, hsys, cusps(0), ascmc(0))

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "geolat=", geolat
PrintDetails "geolon=", geolon
PrintDetails "hsys=", hsys
PrintDetails "cusps(0)=", cusps(0)
PrintDetails "cusps(1)=", cusps(1)
PrintDetails "cusps(2)=", cusps(2)
PrintDetails "cusps(3)=", cusps(3)
PrintDetails "cusps(4)=", cusps(4)
PrintDetails "cusps(5)=", cusps(5)
PrintDetails "cusps(6)=", cusps(6)
PrintDetails "cusps(7)=", cusps(7)
PrintDetails "cusps(8)=", cusps(8)
PrintDetails "cusps(9)=", cusps(9)
PrintDetails "cusps(10)=", cusps(10)
PrintDetails "cusps(11)=", cusps(11)
PrintDetails "cusps(12)=", cusps(12)
PrintDetails "ascmc(0)=", ascmc(0)
PrintDetails "ascmc(1)=", ascmc(1)
PrintDetails "ascmc(2)=", ascmc(2)
PrintDetails "ascmc(3)=", ascmc(3)
PrintDetails "ascmc(4)=", ascmc(4)
PrintDetails "ascmc(5)=", ascmc(5)
PrintDetails "ascmc(6)=", ascmc(6)
PrintDetails "ascmc(7)=", ascmc(7)
PrintDetails "ascmc(8)=", ascmc(8)
PrintDetails "ascmc(9)=", ascmc(9)
PrintDetails "lRet=", lRet

End Sub 'Test51()


Public Sub Test52()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  829]:     ext_def(int) swe_houses_armc(double armc, double geolat, double eps, int hsys, double *cusps, double *ascmc);
'15.3.      swe_houses_armc() and swe_houses_armc_ex2()
'/* house cusps, ascendant and MC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[52]:swe_houses_armc()"
PrintDetails "=========================="

Dim armc As Double            '//right ascension of meridian collie in degrees
Dim geolat As Double          '// latitude,northern is positive & southern is negative
Dim eps As Double             '//Obliquity of ecliptic, in Decimal degrees
Dim hsys As Long              '/* house method, ascii code of one of the letters PKORCAEVXHTBG */
Dim cusps(13) As Double       '/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
Dim ascmc(10) As Double       '/* array of 10 doubles, explained in Manual*/
Dim lRet As Long              'Return value

armc = 90#
geolat = 13#
eps = 23.45
hsys = Asc("P")

lRet = swe_houses_armc(armc, geolat, eps, hsys, cusps(0), ascmc(0))

PrintDetails "armc=", armc
PrintDetails "geolat=", geolat
PrintDetails "eps=", eps
PrintDetails "hsys=", hsys
PrintDetails "cusps(0)=", cusps(0)
PrintDetails "cusps(1)=", cusps(1)
PrintDetails "cusps(2)=", cusps(2)
PrintDetails "cusps(3)=", cusps(3)
PrintDetails "cusps(4)=", cusps(4)
PrintDetails "cusps(5)=", cusps(5)
PrintDetails "cusps(6)=", cusps(6)
PrintDetails "cusps(7)=", cusps(7)
PrintDetails "cusps(8)=", cusps(8)
PrintDetails "cusps(9)=", cusps(9)
PrintDetails "cusps(10)=", cusps(10)
PrintDetails "cusps(11)=", cusps(11)
PrintDetails "cusps(12)=", cusps(12)
PrintDetails "ascmc(0)=", ascmc(0)
PrintDetails "ascmc(1)=", ascmc(1)
PrintDetails "ascmc(2)=", ascmc(2)
PrintDetails "ascmc(3)=", ascmc(3)
PrintDetails "ascmc(4)=", ascmc(4)
PrintDetails "ascmc(5)=", ascmc(5)
PrintDetails "ascmc(6)=", ascmc(6)
PrintDetails "ascmc(7)=", ascmc(7)
PrintDetails "ascmc(8)=", ascmc(8)
PrintDetails "ascmc(9)=", ascmc(9)
PrintDetails "lRet=", lRet

End Sub 'Test52()


Public Sub Test53()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  833]:     ext_def(int) swe_houses_armc_ex2(double armc, double geolat, double eps, int hsys, double *cusps, double *ascmc, double *cusp_speed, double *ascmc_speed, char *serr);
'15.3.      swe_houses_armc() and swe_houses_armc_ex2()
'/* house cusps, ascendant and MC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[53]:swe_houses_armc_ex2()"
PrintDetails "=============================="

Dim armc As Double            '//right ascension of meridian collie
Dim geolat As Double          '// latitude,northern is positive & southern is negative
Dim eps As Double             '//Obliquity of ecliptic, in Decimal degrees
Dim hsys As Long              '/* house method, ascii code of one of the letters PKORCAEVXHTBG */
Dim cusps(13) As Double       '/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
Dim ascmc(10) As Double       '/* array of 10 doubles, explained in Manual*/
Dim cusp_speed(13) As Double  '/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
Dim ascmc_speed(10) As Double '/* array of 10 doubles, explained in Manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

armc = 90#
geolat = 13#
eps = 23.45
hsys = Asc("P")

lRet = swe_houses_armc_ex2(armc, geolat, eps, hsys, cusps(0), ascmc(0), cusp_speed(0), ascmc_speed(0), serr)

PrintDetails "armc=", armc
PrintDetails "geolat=", geolat
PrintDetails "eps=", eps
PrintDetails "hsys=", hsys
PrintDetails "cusps(0)=", cusps(0)
PrintDetails "cusps(1)=", cusps(1)
PrintDetails "cusps(2)=", cusps(2)
PrintDetails "cusps(3)=", cusps(3)
PrintDetails "cusps(4)=", cusps(4)
PrintDetails "cusps(5)=", cusps(5)
PrintDetails "cusps(6)=", cusps(6)
PrintDetails "cusps(7)=", cusps(7)
PrintDetails "cusps(8)=", cusps(8)
PrintDetails "cusps(9)=", cusps(9)
PrintDetails "cusps(10)=", cusps(10)
PrintDetails "cusps(11)=", cusps(11)
PrintDetails "cusps(12)=", cusps(12)
PrintDetails "ascmc(0)=", ascmc(0)
PrintDetails "ascmc(1)=", ascmc(1)
PrintDetails "ascmc(2)=", ascmc(2)
PrintDetails "ascmc(3)=", ascmc(3)
PrintDetails "ascmc(4)=", ascmc(4)
PrintDetails "ascmc(5)=", ascmc(5)
PrintDetails "ascmc(6)=", ascmc(6)
PrintDetails "ascmc(7)=", ascmc(7)
PrintDetails "ascmc(8)=", ascmc(8)
PrintDetails "ascmc(9)=", ascmc(9)
PrintDetails "cusp_speed(0)=", cusp_speed(0)
PrintDetails "cusp_speed(1)=", cusp_speed(1)
PrintDetails "cusp_speed(2)=", cusp_speed(2)
PrintDetails "cusp_speed(3)=", cusp_speed(3)
PrintDetails "cusp_speed(4)=", cusp_speed(4)
PrintDetails "cusp_speed(5)=", cusp_speed(5)
PrintDetails "cusp_speed(6)=", cusp_speed(6)
PrintDetails "cusp_speed(7)=", cusp_speed(7)
PrintDetails "cusp_speed(8)=", cusp_speed(8)
PrintDetails "cusp_speed(9)=", cusp_speed(9)
PrintDetails "cusp_speed(10)=", cusp_speed(10)
PrintDetails "cusp_speed(11)=", cusp_speed(11)
PrintDetails "cusp_speed(12)=", cusp_speed(12)
PrintDetails "ascmc_speed(0)=", ascmc_speed(0)
PrintDetails "ascmc_speed(1)=", ascmc_speed(1)
PrintDetails "ascmc_speed(2)=", ascmc_speed(2)
PrintDetails "ascmc_speed(3)=", ascmc_speed(3)
PrintDetails "ascmc_speed(4)=", ascmc_speed(4)
PrintDetails "ascmc_speed(5)=", ascmc_speed(5)
PrintDetails "ascmc_speed(6)=", ascmc_speed(6)
PrintDetails "ascmc_speed(7)=", ascmc_speed(7)
PrintDetails "ascmc_speed(8)=", ascmc_speed(8)
PrintDetails "ascmc_speed(9)=", ascmc_speed(9)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test53()


Public Sub Test54()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  825]:     ext_def(int) swe_houses_ex2(double tjd_ut, int32 iflag, double geolat, double geolon, int hsys, double *cusps, double *ascmc, double *cusp_speed, double *ascmc_speed, char *serr);
'15.4.      swe_houses_ex() and swe_houses_ex2()
'/* extended function; to compute tropical or sidereal positions of house cusps */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[54]:swe_houses_ex2()"
PrintDetails "========================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim geolat As Double          '// latitude,northern is positive & southern is negative
Dim geolon As Double          '// geographic longitude,East is positive & West is negative
Dim hsys As Long              '/* house method, ascii code of one of the letters PKORCAEVXHTBG */
Dim cusps(13) As Double       '/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
Dim ascmc(10) As Double       '/* array of 10 doubles, explained in Manual*/
Dim cusp_speed(13) As Double  '/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
Dim ascmc_speed(10) As Double '/* array of 10 doubles, explained in Manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value


tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_ut = tjd_ut + swe_deltat(tjd_ut)
iflag = 0
geolat = 13#
geolon = 80#
hsys = Asc("P")

lRet = swe_houses_ex2(tjd_ut, iflag, geolat, geolon, hsys, cusps(0), ascmc(0), cusp_speed(0), ascmc_speed(0), serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "iflag=", iflag
PrintDetails "geolat=", geolat
PrintDetails "geolon=", geolon
PrintDetails "hsys=", hsys
PrintDetails "cusps(0)=", cusps(0)
PrintDetails "cusps(1)=", cusps(1)
PrintDetails "cusps(2)=", cusps(2)
PrintDetails "cusps(3)=", cusps(3)
PrintDetails "cusps(4)=", cusps(4)
PrintDetails "cusps(5)=", cusps(5)
PrintDetails "cusps(6)=", cusps(6)
PrintDetails "cusps(7)=", cusps(7)
PrintDetails "cusps(8)=", cusps(8)
PrintDetails "cusps(9)=", cusps(9)
PrintDetails "cusps(10)=", cusps(10)
PrintDetails "cusps(11)=", cusps(11)
PrintDetails "cusps(12)=", cusps(12)
PrintDetails "ascmc(0)=", ascmc(0)
PrintDetails "ascmc(1)=", ascmc(1)
PrintDetails "ascmc(2)=", ascmc(2)
PrintDetails "ascmc(3)=", ascmc(3)
PrintDetails "ascmc(4)=", ascmc(4)
PrintDetails "ascmc(5)=", ascmc(5)
PrintDetails "ascmc(6)=", ascmc(6)
PrintDetails "ascmc(7)=", ascmc(7)
PrintDetails "ascmc(8)=", ascmc(8)
PrintDetails "ascmc(9)=", ascmc(9)
PrintDetails "cusp_speed(0)=", cusp_speed(0)
PrintDetails "cusp_speed(1)=", cusp_speed(1)
PrintDetails "cusp_speed(2)=", cusp_speed(2)
PrintDetails "cusp_speed(3)=", cusp_speed(3)
PrintDetails "cusp_speed(4)=", cusp_speed(4)
PrintDetails "cusp_speed(5)=", cusp_speed(5)
PrintDetails "cusp_speed(6)=", cusp_speed(6)
PrintDetails "cusp_speed(7)=", cusp_speed(7)
PrintDetails "cusp_speed(8)=", cusp_speed(8)
PrintDetails "cusp_speed(9)=", cusp_speed(9)
PrintDetails "cusp_speed(10)=", cusp_speed(10)
PrintDetails "cusp_speed(11)=", cusp_speed(11)
PrintDetails "cusp_speed(12)=", cusp_speed(12)
PrintDetails "ascmc_speed(0)=", ascmc_speed(0)
PrintDetails "ascmc_speed(1)=", ascmc_speed(1)
PrintDetails "ascmc_speed(2)=", ascmc_speed(2)
PrintDetails "ascmc_speed(3)=", ascmc_speed(3)
PrintDetails "ascmc_speed(4)=", ascmc_speed(4)
PrintDetails "ascmc_speed(5)=", ascmc_speed(5)
PrintDetails "ascmc_speed(6)=", ascmc_speed(6)
PrintDetails "ascmc_speed(7)=", ascmc_speed(7)
PrintDetails "ascmc_speed(8)=", ascmc_speed(8)
PrintDetails "ascmc_speed(9)=", ascmc_speed(9)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test54()


Public Sub Test55()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  821]:     ext_def(int) swe_houses_ex(double tjd_ut, int32 iflag, double geolat, double geolon, int hsys, double *cusps, double *ascmc);
'15.4.      swe_houses_ex() and swe_houses_ex2()
'/* extended function; to compute tropical or sidereal positions of house cusps */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================"
PrintDetails "Test[55]:swe_houses_ex()"
PrintDetails "========================"

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim geolat As Double          '// latitude,northern is positive & southern is negative
Dim geolon As Double          '// geographic longitude,East is positive & West is negative
Dim hsys As Long              '/* house method, ascii code of one of the letters PKORCAEVXHTBG */
Dim cusps(13) As Double       '/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
Dim ascmc(10) As Double       '/* array of 10 doubles, explained in Manual*/
Dim lRet As Long              'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_ut = tjd_ut + swe_deltat(tjd_ut)
iflag = 0
geolat = 13#
geolon = 80#
hsys = Asc("P")

lRet = swe_houses_ex(tjd_ut, iflag, geolat, geolon, hsys, cusps(0), ascmc(0))

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "iflag=", iflag
PrintDetails "geolat=", geolat
PrintDetails "geolon=", geolon
PrintDetails "hsys=", hsys
PrintDetails "cusps(0)=", cusps(0)
PrintDetails "cusps(1)=", cusps(1)
PrintDetails "cusps(2)=", cusps(2)
PrintDetails "cusps(3)=", cusps(3)
PrintDetails "cusps(4)=", cusps(4)
PrintDetails "cusps(5)=", cusps(5)
PrintDetails "cusps(6)=", cusps(6)
PrintDetails "cusps(7)=", cusps(7)
PrintDetails "cusps(8)=", cusps(8)
PrintDetails "cusps(9)=", cusps(9)
PrintDetails "cusps(10)=", cusps(10)
PrintDetails "cusps(11)=", cusps(11)
PrintDetails "cusps(12)=", cusps(12)
PrintDetails "ascmc(0)=", ascmc(0)
PrintDetails "ascmc(1)=", ascmc(1)
PrintDetails "ascmc(2)=", ascmc(2)
PrintDetails "ascmc(3)=", ascmc(3)
PrintDetails "ascmc(4)=", ascmc(4)
PrintDetails "ascmc(5)=", ascmc(5)
PrintDetails "ascmc(6)=", ascmc(6)
PrintDetails "ascmc(7)=", ascmc(7)
PrintDetails "ascmc(8)=", ascmc(8)
PrintDetails "ascmc(9)=", ascmc(9)
PrintDetails "lRet=", lRet

End Sub 'Test55()


Public Sub Test56()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  796]:     ext_def(void) swe_jdet_to_utc(double tjd_et, int32 gregflag, int32 *iyear, int32 *imonth, int32 *iday, int32 *ihour, int32 *imin, double *dsec);
'18.3.7.      TT (ET1) to UTC
'/* input: Julian day number in ET (TT), calendar flag
'/* output: year, month, day, hour, min, sec in UTC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[56]:swe_jdet_to_utc()"
PrintDetails "=========================="

Dim tjd_et As Double          '//julian Day Number in ET/TT
Dim gregflag As Long          '/*calendars Flag for Calculation.See User's manual */
Dim iyear As Long             '//Year in the date
Dim imonth As Long            '//Month in the date
Dim iday As Long              '//Day in the date
Dim ihour As Long             '//Integer part of  Decimal hour
Dim imin As Long              '//Integer minute part of  Decimal hour
Dim dsec As Double            '//Decimal Seconds


tjd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd_et = tjd_et + swe_deltat(tjd_et)
gregflag = SE_GREG_CAL

Call swe_jdet_to_utc(tjd_et, gregflag, iyear, imonth, iday, ihour, imin, dsec)

PrintDetails "tjd_et=", tjd_et
PrintDetails "gregflag=", gregflag
PrintDetails "iyear=", iyear
PrintDetails "imonth=", imonth
PrintDetails "iday=", iday
PrintDetails "ihour=", ihour
PrintDetails "imin=", imin
PrintDetails "dsec=", dsec

End Sub 'Test56()


Public Sub Test57()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  801]:     ext_def(void) swe_jdut1_to_utc(double tjd_ut, int32 gregflag, int32 *iyear, int32 *imonth, int32 *iday, int32 *ihour, int32 *imin, double *dsec);
'18.3.8.      UTC to TT (ET1)
'/* input: Julian day number in UT (UT1), calendar flag
'/* output: year, month, day, hour, min, sec in UTC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==========================="
PrintDetails "Test[57]:swe_jdut1_to_utc()"
PrintDetails "==========================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim gregflag As Long          '/*calendars Flag for Calculation.See User's manual */
Dim iyear As Long             '//Year in the date
Dim imonth As Long            '//Month in the date
Dim iday As Long              '//Day in the date
Dim ihour As Long             '//Integer part of  Decimal hour
Dim imin As Long              '//Integer minute part of  Decimal hour
Dim dsec As Double            '//Decimal Seconds

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_et = tjd_et + swe_deltat(tjd_et)
gregflag = SE_GREG_CAL
Call swe_jdut1_to_utc(tjd_ut, gregflag, iyear, imonth, iday, ihour, imin, dsec)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "gregflag=", gregflag
PrintDetails "iyear=", iyear
PrintDetails "imonth=", imonth
PrintDetails "iday=", iday
PrintDetails "ihour=", ihour
PrintDetails "imin=", imin
PrintDetails "dsec=", dsec

End Sub 'Test57()


Public Sub Test58()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  782]:     ext_def(double) swe_julday(int year, int month, int day, double hour,int gregflag);
'9.         Date and time conversion functions
'9.1.  Calendar date and Julian day: swe_julday(), swe_date_conversion(), /swe_revjul()
'These functions converts calendar dates to the astronomical time scale which measures time in Julian days.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[58]:swe_julday()"
PrintDetails "====================="

Dim year As Long              '//Year of the date
Dim month As Long             '//Month of the date
Dim day As Long               '//Day in the date
Dim hour As Double            '//Time in decimal Hours
Dim gregflag As Long          '/*calendars Flag for Calculation.See User's manual */
Dim dret As Double            'Return value

year = 2021
month = 10
day = 1
hour = 10#
gregflag = SE_GREG_CAL

dret = swe_julday(year, month, day, hour, gregflag)

PrintDetails "year=", year
PrintDetails "month=", month
PrintDetails "day=", day
PrintDetails "hour=", hour
PrintDetails "gregflag=", gregflag
PrintDetails "dRet=", dret

End Sub 'Test58()


Public Sub Test59()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  958]:     ext_def(int32) swe_lat_to_lmt(double tjd_lat, double geolon, double *tjd_lmt, char *serr);
'9.4.  Mean solar time versus True solar time: swe_time_equ(), swe_lmt_to_lat(), swe_lat_to_lmt()
'/* converts Local Apparent Time (LAT) to Local Mean Time (LMT) */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[59]:swe_lat_to_lmt()"
PrintDetails "========================="

Dim tjd_lat As Double         '//julian Day Number for Local Apparent Time
Dim geolon As Double          '// geographic longitude,East is positive & West is negative
Dim tjd_lmt As Double         '//Julian Day Number Local Mean Time (LMT)
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_lat = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
geolon = 80#
lRet = swe_lat_to_lmt(tjd_lat, geolon, tjd_lmt, serr)

PrintDetails "tjd_lat=", tjd_lat
PrintDetails "geolon=", geolon
PrintDetails "tjd_lmt=", tjd_lmt
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test59()


Public Sub Test60()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  957]:     ext_def(int32) swe_lmt_to_lat(double tjd_lmt, double geolon, double *tjd_lat, char *serr);
'9.4.  Mean solar time versus True solar time: swe_time_equ(), swe_lmt_to_lat(), swe_lat_to_lmt()
'/* converts Local Mean Time (LMT) to Local Apparent Time (LAT) */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[60]:swe_lmt_to_lat()"
PrintDetails "========================="

Dim tjd_lmt As Double         '//julian Day Number for Local Mean Time
Dim geolon As Double          '// geographic longitude,East is positive & West is negative
Dim tjd_lat As Double         '//Julian Day Number Local Apparent Time (LAT)
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_lmt = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
geolon = 80#

lRet = swe_lmt_to_lat(tjd_lmt, geolon, tjd_lat, serr)

PrintDetails "tjd_lmt=", tjd_lmt
PrintDetails "geolon=", geolon
PrintDetails "tjd_lat=", tjd_lat
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test60()


Public Sub Test61()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  874]:     ext_def(int32) swe_lun_eclipse_how(double tjd_ut,int32 ifl,double *geopos,double *attr,char *serr);
'8.11.      swe_lun_eclipse_how ()
'This function computes the attributes of a lunar eclipse at a given time:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[61]:swe_lun_eclipse_how()"
PrintDetails "=============================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim ifl As Long               '/* Ephemeris Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ifl = SEFLG_MOSEPH
geopos(0) = 80#
geopos(1) = 13#
geopos(2) = 0

lRet = swe_lun_eclipse_how(tjd_ut, ifl, geopos(0), attr(0), serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "ifl=", ifl
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test61()


Public Sub Test62()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  881]:     ext_def(int32) swe_lun_eclipse_when(double tjd_start, int32 ifl, int32 ifltype,double *tret, int32 backward, char *serr);
'8.10.      swe_lun_eclipse_when ()
'To find the next lunar eclipse:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==============================="
PrintDetails "Test[62]:swe_lun_eclipse_when()"
PrintDetails "==============================="

Dim tjd_start As Double       '/* start date for search, Jul. day UT */
Dim ifl As Long               '/* Ephemeris Flag for Calculation. See user's manual */
Dim ifltype As Long           '/* Flag for Calculation. See user's manual */
Dim tret(10) As Double        '//Time details /* return array, Array of 10 doubles, see User's manual */
Dim backward As Long          '/* TRUE, if backward search */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_start = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ifl = SEFLG_MOSEPH
ifltype = 0

lRet = swe_lun_eclipse_when(tjd_start, ifl, ifltype, tret(0), backward, serr)

PrintDetails "tjd_start=", tjd_start
PrintDetails "ifl=", ifl
PrintDetails "ifltype=", ifltype
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "backward=", backward
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test62()


Public Sub Test63()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  884]:     ext_def(int32) swe_lun_eclipse_when_loc(double tjd_start, int32 ifl,double *geopos, double *tret, double *attr, int32 backward, char *serr);
'8.9.  swe_lun_eclipse_when_loc ()
'To find the next lunar eclipse observable from a given geographic position:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==================================="
PrintDetails "Test[63]:swe_lun_eclipse_when_loc()"
PrintDetails "==================================="

Dim tjd_start As Double       '/* start date for search, Jul. day UT */
Dim ifl As Long               '/* Ephemeris Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim tret(10) As Double        '//Time details /* return array, array of 10 doubles, see User's manual */
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim backward As Long          '/* TRUE, if backward search */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_start = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ifl = SEFLG_MOSEPH
geopos(0) = 80#
geopos(1) = 13#
geopos(2) = 0#

lRet = swe_lun_eclipse_when_loc(tjd_start, ifl, geopos(0), tret(0), attr(0), backward, serr)

PrintDetails "tjd_start=", tjd_start
PrintDetails "ifl=", ifl
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "backward=", backward
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test63()


Public Sub Test64()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  870]:     ext_def(int32) swe_lun_occult_when_glob(double tjd_start, int32 ipl, char *starname, int32 ifl, int32 ifltype,double *tret, int32 backward, char *serr);
'8.7.  swe_lun_occult_when_glob()
'To find the next occultation of a planet or star by the moon globally
'(not for a particular geographic location),use swe_lun_occult_when_glob().
'The same function can also be used for global solar eclipses instead of
'swe_sol_eclipse_when_glob(), but is a bit less efficient.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==================================="
PrintDetails "Test[64]:swe_lun_occult_when_glob()"
PrintDetails "==================================="

Dim tjd_start As Double       '/* start date for search, Jul. day UT */
Dim ipl As Long               '//fixed set of body numbers
Dim starname As String        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
starname = Space$(256)        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim ifl As Long               '/*Ephemeris Flag for Calculation. See user's manual */
Dim ifltype As Long           '/* Flag for Calculation. See user's manual */
Dim tret(10) As Double        '//Time details /* return array, Array of 10 doubles, see User's manual */
Dim backward As Long          '/* TRUE, if backward search */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_start = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ipl = 2
starname = ""
ifl = SEFLG_MOSEPH
ifltype = 0
backward = False 'True

lRet = swe_lun_occult_when_glob(tjd_start, ipl, starname, ifl, ifltype, tret(0), backward, serr)

PrintDetails "tjd_start=", tjd_start
PrintDetails "ipl=", ipl
PrintDetails "starname=", TrimNullChar(starname)
PrintDetails "ifl=", ifl
PrintDetails "ifltype=", ifltype
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "backward=", backward
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test64()


Public Sub Test65()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  862]:     ext_def(int32) swe_lun_occult_when_loc(double tjd_start, int32 ipl, char *starname, int32 ifl,double *geopos, double *tret, double *attr, int32 backward, char *serr);
'8.6.  swe_lun_occult_when_loc()
'To find the next occultation of a planet or star by the moon for a given location
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=================================="
PrintDetails "Test[65]:swe_lun_occult_when_loc()"
PrintDetails "=================================="

Dim tjd_start As Double       '/* start date for search, Jul. day UT */
Dim ipl As Long               '//fixed set of body numbers
Dim starname As String        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
starname = Space$(256)        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim ifl As Long               '/*Ephemeris Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim tret(10) As Double        '//Time details /* return array, Array of 10 doubles, see User's manual */
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim backward As Long          '/* TRUE, if backward search */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_start = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ipl = 2
starname = ""
ifl = SEFLG_MOSEPH
geopos(0) = 80#
geopos(1) = 13#
geopos(2) = 0
backward = False 'True

lRet = swe_lun_occult_when_loc(tjd_start, ipl, starname, ifl, geopos(0), tret(0), attr(0), backward, serr)

PrintDetails "tjd_start=", tjd_start
PrintDetails "ipl=", ipl
PrintDetails "starname=", TrimNullChar(starname)
PrintDetails "ifl=", ifl
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "backward=", backward
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test65()


Public Sub Test66()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  854]:     ext_def(int32) swe_lun_occult_where(double tjd, int32 ipl, char *starname, int32 ifl, double *geopos, double *attr, char *serr);
'8.8.  swe_lun_occult_where ()
'Similar to swe_sol_eclipse_where(), this function can be used
'to find out the geographic position, where, for a given time,
'a central eclipse is central or where a non-central eclipse is maximal.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==============================="
PrintDetails "Test[66]:swe_lun_occult_where()"
PrintDetails "==============================="

Dim tjd As Double             '//Julian Day Number
Dim ipl As Long               '//fixed set of body numbers
Dim starname As String        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
starname = Space$(256)        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim ifl As Long               '/*Ephemeris Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ipl = 2
starname = ""
ifl = SEFLG_MOSEPH
'geopos(0) = 80#
'geopos(1) = 13#
'geopos(2) = 0

lRet = swe_lun_occult_where(tjd, ipl, starname, ifl, geopos(0), attr(0), serr)

PrintDetails "tjd=", tjd
PrintDetails "ipl=", ipl
PrintDetails "starname=", TrimNullChar(starname)
PrintDetails "ifl=", ifl
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test66()


Public Sub Test67()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  714]:     ext_def(double) swe_mooncross(double x2cross, double jd_et, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================"
PrintDetails "Test[67]:swe_mooncross()"
PrintDetails "========================"

Dim x2cross As Double         '//heliocentric crossings over a position x2cross
Dim jd_et As Double           '//Julian day, Ephemeris time/TT
Dim flag As Long              '/* Flag for Calculation. See user's manual */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

x2cross = 120#
jd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
jd_et = jd_et + swe_deltat(jd_et)
flag = SEFLG_TRUEPOS

dret = swe_mooncross(x2cross, jd_et, flag, serr)

PrintDetails "x2cross=", x2cross
PrintDetails "jd_et=", jd_et
PrintDetails "flag=", flag
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test67()


Public Sub Test68()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  716]:     ext_def(double) swe_mooncross_node(double jd_et, int32 flag, double *xlon, double *xlat, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over its true node,
'i.e. crossing through the ecliptic.
'/*compute next Moon crossing over node, by finding zero latitude crossing
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "============================="
PrintDetails "Test[68]:swe_mooncross_node()"
PrintDetails "============================="

Dim jd_et As Double           '//Julian day, Ephemeris time/TT
Dim flag As Long              '/* Flag for Calculation. See user's manual */
Dim xlon As Double            '//Longitude in Degrees
Dim xlat As Double            '//Latitude in Degrees
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

jd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
jd_et = jd_et + swe_deltat(jd_et)
flag = SEFLG_TRUEPOS

dret = swe_mooncross_node(jd_et, flag, xlon, xlat, serr)

PrintDetails "jd_et=", jd_et
PrintDetails "flag=", flag
PrintDetails "xlon=", xlon
PrintDetails "xlat=", xlat
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test68()


Public Sub Test69()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  717]:     ext_def(double) swe_mooncross_node_ut(double jd_ut, int32 flag, double *xlon, double *xlat, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over its true node,
'i.e. crossing through the ecliptic.
'/*compute next Moon crossing over node, by finding zero latitude crossing
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "================================"
PrintDetails "Test[69]:swe_mooncross_node_ut()"
PrintDetails "================================"

Dim jd_ut As Double           '//Julian day, universal time (UT)
Dim flag As Long              '/* Flag for Calculation. See user's manual */
Dim xlon As Double            '//Longitude in Degrees
Dim xlat As Double            '//Latitude in Degrees
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

jd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'jd_et = jd_et + swe_deltat(jd_et)
flag = SEFLG_TRUEPOS

dret = swe_mooncross_node_ut(jd_ut, flag, xlon, xlat, serr)

PrintDetails "jd_ut=", jd_ut
PrintDetails "flag=", flag
PrintDetails "xlon=", xlon
PrintDetails "xlat=", xlat
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test69()


Public Sub Test70()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  715]:     ext_def(double) swe_mooncross_ut(double x2cross, double jd_ut, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==========================="
PrintDetails "Test[70]:swe_mooncross_ut()"
PrintDetails "==========================="

Dim x2cross As Double         '//heliocentric crossings over a position x2cross
Dim jd_ut As Double           '//Julian day, universal time (UT)
Dim flag As Long              '/* Flag for Calculation. See user's manual */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

x2cross = 120#
jd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'jd_et = jd_et + swe_deltat(jd_et)
flag = SEFLG_TRUEPOS

dret = swe_mooncross_ut(x2cross, jd_ut, flag, serr)

PrintDetails "x2cross=", x2cross
PrintDetails "jd_ut=", jd_ut
PrintDetails "flag=", flag
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test70()


Public Sub Test71()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  931]:     ext_def(int32) swe_nod_aps(double tjd_et, int32 ipl, int32 iflag,int32 method,double *xnasc, double *xndsc,double *xperi, double *xaphe,char *serr);
'7.         Apsides and nodes, Kepler elements and orbital periods
'7.1.  swe_nod_aps_ut() and swe_nod_aps()
'compute planetary nodes and apsides (perihelia, aphelia,
'second focal points of the orbital ellipses).
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================"
PrintDetails "Test[71]:swe_nod_aps()"
PrintDetails "======================"

Dim tjd_et As Double          '//julian Day Number in ET/TT
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim method As Long            '/* Flag for Calculation. See user's manual */
Dim xnasc(6) As Double        '// array of 6 double for ascending node
Dim xndsc(6) As Double        '// array of 6 double for ascending node
Dim xperi(6) As Double        '// array of 6 double for perihelion
Dim xaphe(6) As Double        '/* array of 6 double for aphelion*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd_et = tjd_et + swe_deltat(tjd_et)
ipl = 2
iflag = SEFLG_MOSEPH
method = 0

lRet = swe_nod_aps(tjd_et, ipl, iflag, method, xnasc(0), xndsc(0), xperi(0), xaphe(0), serr)

PrintDetails "tjd_et=", tjd_et
PrintDetails "ipl=", ipl
PrintDetails "iflag=", iflag
PrintDetails "method=", method
PrintDetails "xnasc(0)=", xnasc(0)
PrintDetails "xnasc(1)=", xnasc(1)
PrintDetails "xnasc(2)=", xnasc(2)
PrintDetails "xnasc(3)=", xnasc(3)
PrintDetails "xnasc(4)=", xnasc(4)
PrintDetails "xnasc(5)=", xnasc(5)
PrintDetails "xndsc(0)=", xndsc(0)
PrintDetails "xndsc(1)=", xndsc(1)
PrintDetails "xndsc(2)=", xndsc(2)
PrintDetails "xndsc(3)=", xndsc(3)
PrintDetails "xndsc(4)=", xndsc(4)
PrintDetails "xndsc(5)=", xndsc(5)
PrintDetails "xperi(0)=", xperi(0)
PrintDetails "xperi(1)=", xperi(1)
PrintDetails "xperi(2)=", xperi(2)
PrintDetails "xperi(3)=", xperi(3)
PrintDetails "xperi(4)=", xperi(4)
PrintDetails "xperi(5)=", xperi(5)
PrintDetails "xaphe(0)=", xaphe(0)
PrintDetails "xaphe(1)=", xaphe(1)
PrintDetails "xaphe(2)=", xaphe(2)
PrintDetails "xaphe(3)=", xaphe(3)
PrintDetails "xaphe(4)=", xaphe(4)
PrintDetails "xaphe(5)=", xaphe(5)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test71()


Public Sub Test72()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  937]:     ext_def(int32) swe_nod_aps_ut(double tjd_ut, int32 ipl, int32 iflag,int32 method,double *xnasc, double *xndsc,double *xperi, double *xaphe,char *serr);
'7.         Apsides and nodes, Kepler elements and orbital periods
'7.1.  swe_nod_aps_ut() and swe_nod_aps()
'modified version of swe_nod_aps
'compute planetary nodes and apsides (perihelia, aphelia,
'second focal points of the orbital ellipses).
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[72]:swe_nod_aps_ut()"
PrintDetails "========================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim method As Long            '/* Flag for Calculation. See user's manual */
Dim xnasc(6) As Double        '// array of 6 double for ascending node
Dim xndsc(6) As Double        '// array of 6 double for ascending node
Dim xperi(6) As Double        '// array of 6 double for perihelion
Dim xaphe(6) As Double        '/* array of 6 double for aphelion*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_et = tjd_et + swe_deltat(tjd_et)
ipl = 2
iflag = SEFLG_MOSEPH
method = 0

lRet = swe_nod_aps_ut(tjd_ut, ipl, iflag, method, xnasc(0), xndsc(0), xperi(0), xaphe(0), serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "ipl=", ipl
PrintDetails "iflag=", iflag
PrintDetails "method=", method
PrintDetails "xnasc(0)=", xnasc(0)
PrintDetails "xnasc(1)=", xnasc(1)
PrintDetails "xnasc(2)=", xnasc(2)
PrintDetails "xnasc(3)=", xnasc(3)
PrintDetails "xnasc(4)=", xnasc(4)
PrintDetails "xnasc(5)=", xnasc(5)
PrintDetails "xndsc(0)=", xndsc(0)
PrintDetails "xndsc(1)=", xndsc(1)
PrintDetails "xndsc(2)=", xndsc(2)
PrintDetails "xndsc(3)=", xndsc(3)
PrintDetails "xndsc(4)=", xndsc(4)
PrintDetails "xndsc(5)=", xndsc(5)
PrintDetails "xperi(0)=", xperi(0)
PrintDetails "xperi(1)=", xperi(1)
PrintDetails "xperi(2)=", xperi(2)
PrintDetails "xperi(3)=", xperi(3)
PrintDetails "xperi(4)=", xperi(4)
PrintDetails "xperi(5)=", xperi(5)
PrintDetails "xaphe(0)=", xaphe(0)
PrintDetails "xaphe(1)=", xaphe(1)
PrintDetails "xaphe(2)=", xaphe(2)
PrintDetails "xaphe(3)=", xaphe(3)
PrintDetails "xaphe(4)=", xaphe(4)
PrintDetails "xaphe(5)=", xaphe(5)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test72()


Public Sub Test73()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  945]:     ext_def(int32) swe_orbit_max_min_true_distance(double tjd_et, int32 ipl, int32 iflag, double *dmax, double *dmin, double *dtrue, char *serr);
'7.3.  swe_orbit_max_min_true_distance()
'This function calculates the maximum possible distance,
'the minimum possible distance, and the current true distance
'of planet,the EMB, or an asteroid.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================================="
PrintDetails "Test[73]:swe_orbit_max_min_true_distance()"
PrintDetails "=========================================="

Dim tjd_et As Double          '//julian Day Number in ET/TT
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* ephemeris flag and optional heliocentric flag for Calculation. See user's manual */
Dim dmax As Double            '// return value: maximum distance based on osculating elements
Dim dmin As Double            '// return value: minimum distance based on osculating elements
Dim dtrue As Double           '// return value: current distance
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value


tjd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd_et = tjd_et + swe_deltat(tjd_et)
ipl = 2
iflag = SEFLG_MOSEPH

lRet = swe_orbit_max_min_true_distance(tjd_et, ipl, iflag, dmax, dmin, dtrue, serr)

PrintDetails "tjd_et=", tjd_et
PrintDetails "ipl=", ipl
PrintDetails "iflag=", iflag
PrintDetails "dmax=", dmax
PrintDetails "dmin=", dmin
PrintDetails "dtrue=", dtrue
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test73()


Public Sub Test74()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  888]:     ext_def(int32) swe_pheno(double tjd, int32 ipl, int32 iflag, double *attr, char *serr);
'8.13.      swe_pheno_ut() and swe_pheno(), planetary phenomena
'These functions compute phase, phase angle, elongation, apparent diameter,
'apparent magnitude for the Sun, the Moon, all planets and asteroids.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "===================="
PrintDetails "Test[74]:swe_pheno()"
PrintDetails "===================="

Dim tjd As Double             '//Julian Day Number, ET/TT
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
tjd = tjd + swe_deltat(tjd)
ipl = 2
iflag = SEFLG_MOSEPH

lRet = swe_pheno(tjd, ipl, iflag, attr(0), serr)

PrintDetails "tjd=", tjd
PrintDetails "ipl=", ipl
PrintDetails "iflag=", iflag
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test74()


Public Sub Test75()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  890]:     ext_def(int32) swe_pheno_ut(double tjd_ut, int32 ipl, int32 iflag, double *attr, char *serr);
'8.13.      swe_pheno_ut() and swe_pheno(), planetary phenomena
'These functions compute phase, phase angle, elongation, apparent diameter,
'apparent magnitude for the Sun, the Moon, all planets and asteroids.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[75]:swe_pheno_ut()"
PrintDetails "======================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim ipl As Long               '//fixed set of body numbers
Dim iflag As Long             '/* Flag for Calculation. See user's manual */
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value


tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'tjd_et = tjd_et + swe_deltat(tjd_et)
ipl = 2
iflag = SEFLG_MOSEPH

lRet = swe_pheno_ut(tjd_ut, ipl, iflag, attr(0), serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "ipl=", ipl
PrintDetails "iflag=", iflag
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test75()


Public Sub Test76()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  979]:     ext_def(double) swe_rad_midp(double x1, double x0);
'***********************(obsolete/Internal use)*******************
'/* finds midpoint of the arc from x0 to x1 radian range 0 ... pi*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[76]:swe_rad_midp()"
PrintDetails "======================="

Dim x1 As Double              '//Value in Radian
Dim x0 As Double              '//Value in Radian
Dim dret As Double            'Return value

x0 = 4#
x1 = 1#
dret = swe_rad_midp(x1, x0)

PrintDetails "x1=", x1
PrintDetails "x0=", x0
PrintDetails "dRet=", dret

End Sub 'Test76()


Public Sub Test77()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  978]:     ext_def(double) swe_radnorm(double x);
'18.6.5.      swe_radnorm(): normalize radians to the range 0 ... 2 PI
'normalize x radians to the range 0 ... 2phi
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================"
PrintDetails "Test[77]:swe_radnorm()"
PrintDetails "======================"

Dim x As Double               '//Value in Radian
Dim dret As Double            'Return value

x = 7#
dret = swe_radnorm(x)

PrintDetails "x=", x
PrintDetails "dRet=", dret

End Sub 'Test77()


Public Sub Test78()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  892]:     ext_def(double) swe_refrac(double inalt, double atpress, double attemp, int32 calc_flag);
'8.16.      swe_refrac(), swe_refrac_extended(), refraction
'This refraction function calculates either the true altitude from
'the apparent altitude or the apparent altitude from the apparent altitude.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[78]:swe_refrac()"
PrintDetails "====================="

Dim inalt As Double           '/* altitude of object above geometric horizon in degrees, where geometric horizon = plane perpendicular to gravity */
Dim atpress As Double         '/* atmospheric pressure in mbar/hPa */
Dim attemp As Double          '// atmospheric temperature in degrees Celsius
Dim calc_flag As Long         '/* Flag for Calculation. See user's manual */
Dim dret As Double            'Return value


inalt = 10
atpress = 105
attemp = 35#
calc_flag = SE_APP_TO_TRUE

dret = swe_refrac(inalt, atpress, attemp, calc_flag)

PrintDetails "inalt=", inalt
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "calc_flag=", calc_flag
PrintDetails "dRet=", dret


inalt = dret
atpress = 105
attemp = 35#
calc_flag = SE_TRUE_TO_APP

dret = swe_refrac(inalt, atpress, attemp, calc_flag)

PrintDetails "inalt=", inalt
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "calc_flag=", calc_flag
PrintDetails "dRet=", dret

'The refraction depends on the atmospheric pressure and temperature at the location of the observer.
'If atpress is given the value 0, the function estimates the pressure from the geographical altitude given in geopos[2] and attemp. If geopos[2] is 0, atpress will be estimated for sea level.
'There is also a more sophisticated function swe_refrac_extended(). It allows correct calculation of refraction for altitudes above sea > 0, where the ideal horizon and planets that are visible may have a negative height. (for swe_refrac(), negative apparent heights do not exist!)

End Sub 'Test78()

Public Sub Test79()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  894]:     ext_def(double) swe_refrac_extended(double inalt, double geoalt, double atpress, double attemp, double lapse_rate, int32 calc_flag, double *dret);
'8.16.      swe_refrac(), swe_refrac_extended(), refraction
'This refraction function calculates either the true altitude from
'the apparent altitude or the apparent altitude from the apparent altitude.
'It allows correct calculation of refraction for altitudes above sea > 0,
'where the ideal horizon and planets that are visible may have a negative
'height. (for swe_refrac(), negative apparent heights do not exist!)
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[79]:swe_refrac_extended()"
PrintDetails "=============================="

Dim inalt As Double           '/* altitude of object above geometric horizon in degrees, where geometric horizon = plane perpendicular to gravity */
Dim geoalt As Double          '/* altitude of observer above sea level in meters */
Dim atpress As Double         '/* atmospheric pressure in mbar/hPa */
Dim attemp As Double          '// atmospheric temperature in degrees Celsius
Dim lapse_rate As Double      '/* (dattemp/dgeoalt) = [K/m] */
Dim calc_flag As Long         '/* Flag for Calculation. See user's manual */
Dim dret(50) As Double        '/* result: Return array, See User's manual */Declare array of 50 doubles
Dim dRetn As Double           'Return value

'* - dret[0] true altitude, if possible; otherwise input value
'* - dret[1] apparent altitude, if possible; otherwise input value
'* - dret[2] refraction
'* - dret[3] dip of the horizon

inalt = 10#
geoalt = 100#
atpress = 105
attemp = 35#
lapse_rate = 5#
calc_flag = SE_TRUE_TO_APP

dRetn = swe_refrac_extended(inalt, geoalt, atpress, attemp, lapse_rate, calc_flag, dret(0))

PrintDetails "inalt=", inalt
PrintDetails "geoalt=", geoalt
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "lapse_rate=", lapse_rate
PrintDetails "calc_flag=", calc_flag
PrintDetails "dret(0)=", dret(0)
PrintDetails "dret(1)=", dret(1)
PrintDetails "dret(2)=", dret(2)
PrintDetails "dret(3)=", dret(3)
PrintDetails "dret(4)=", dret(4)
PrintDetails "dret(5)=", dret(5)
PrintDetails "dret(6)=", dret(6)
PrintDetails "dret(7)=", dret(7)
PrintDetails "dret(8)=", dret(8)
PrintDetails "dret(9)=", dret(9)
PrintDetails "dret(10)=", dret(10)
PrintDetails "dret(11)=", dret(11)
PrintDetails "dret(12)=", dret(12)
PrintDetails "dret(13)=", dret(13)
PrintDetails "dret(14)=", dret(14)
PrintDetails "dret(15)=", dret(15)
PrintDetails "dret(16)=", dret(16)
PrintDetails "dret(17)=", dret(17)
PrintDetails "dret(18)=", dret(18)
PrintDetails "dret(19)=", dret(19)
PrintDetails "dret(20)=", dret(20)
PrintDetails "dret(21)=", dret(21)
PrintDetails "dret(22)=", dret(22)
PrintDetails "dret(23)=", dret(23)
PrintDetails "dret(24)=", dret(24)
PrintDetails "dret(25)=", dret(25)
PrintDetails "dret(26)=", dret(26)
PrintDetails "dret(27)=", dret(27)
PrintDetails "dret(28)=", dret(28)
PrintDetails "dret(29)=", dret(29)
PrintDetails "dret(30)=", dret(30)
PrintDetails "dret(31)=", dret(31)
PrintDetails "dret(32)=", dret(32)
PrintDetails "dret(33)=", dret(33)
PrintDetails "dret(34)=", dret(34)
PrintDetails "dret(35)=", dret(35)
PrintDetails "dret(36)=", dret(36)
PrintDetails "dret(37)=", dret(37)
PrintDetails "dret(38)=", dret(38)
PrintDetails "dret(39)=", dret(39)
PrintDetails "dret(40)=", dret(40)
PrintDetails "dret(41)=", dret(41)
PrintDetails "dret(42)=", dret(42)
PrintDetails "dret(43)=", dret(43)
PrintDetails "dret(44)=", dret(44)
PrintDetails "dret(45)=", dret(45)
PrintDetails "dret(46)=", dret(46)
PrintDetails "dret(47)=", dret(47)
PrintDetails "dret(48)=", dret(48)
PrintDetails "dret(49)=", dret(49)
PrintDetails "dRetn=", dRetn
If dret(0) <> dret(1) Then
    PrintDetails "dret(0) <> dret(1):", "The body is above the horizon"
Else
    PrintDetails "dret(0) = dret(1):", "The body is belowe the horizon"
End If

inalt = dRetn
geoalt = 100#
atpress = 105
attemp = 35#
lapse_rate = 5#
calc_flag = SE_APP_TO_TRUE 'SE_TRUE_TO_APP

dRetn = swe_refrac_extended(inalt, geoalt, atpress, attemp, lapse_rate, calc_flag, dret(0))

PrintDetails "inalt=", inalt
PrintDetails "geoalt=", geoalt
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "lapse_rate=", lapse_rate
PrintDetails "calc_flag=", calc_flag
PrintDetails "dret(0)=", dret(0)
PrintDetails "dret(1)=", dret(1)
PrintDetails "dret(2)=", dret(2)
PrintDetails "dret(3)=", dret(3)
PrintDetails "dret(4)=", dret(4)
PrintDetails "dret(5)=", dret(5)
PrintDetails "dret(6)=", dret(6)
PrintDetails "dret(7)=", dret(7)
PrintDetails "dret(8)=", dret(8)
PrintDetails "dret(9)=", dret(9)
PrintDetails "dret(10)=", dret(10)
PrintDetails "dret(11)=", dret(11)
PrintDetails "dret(12)=", dret(12)
PrintDetails "dret(13)=", dret(13)
PrintDetails "dret(14)=", dret(14)
PrintDetails "dret(15)=", dret(15)
PrintDetails "dret(16)=", dret(16)
PrintDetails "dret(17)=", dret(17)
PrintDetails "dret(18)=", dret(18)
PrintDetails "dret(19)=", dret(19)
PrintDetails "dret(20)=", dret(20)
PrintDetails "dret(21)=", dret(21)
PrintDetails "dret(22)=", dret(22)
PrintDetails "dret(23)=", dret(23)
PrintDetails "dret(24)=", dret(24)
PrintDetails "dret(25)=", dret(25)
PrintDetails "dret(26)=", dret(26)
PrintDetails "dret(27)=", dret(27)
PrintDetails "dret(28)=", dret(28)
PrintDetails "dret(29)=", dret(29)
PrintDetails "dret(30)=", dret(30)
PrintDetails "dret(31)=", dret(31)
PrintDetails "dret(32)=", dret(32)
PrintDetails "dret(33)=", dret(33)
PrintDetails "dret(34)=", dret(34)
PrintDetails "dret(35)=", dret(35)
PrintDetails "dret(36)=", dret(36)
PrintDetails "dret(37)=", dret(37)
PrintDetails "dret(38)=", dret(38)
PrintDetails "dret(39)=", dret(39)
PrintDetails "dret(40)=", dret(40)
PrintDetails "dret(41)=", dret(41)
PrintDetails "dret(42)=", dret(42)
PrintDetails "dret(43)=", dret(43)
PrintDetails "dret(44)=", dret(44)
PrintDetails "dret(45)=", dret(45)
PrintDetails "dret(46)=", dret(46)
PrintDetails "dret(47)=", dret(47)
PrintDetails "dret(48)=", dret(48)
PrintDetails "dret(49)=", dret(49)
PrintDetails "dRetn=", dRetn
If dret(0) <> dret(1) Then
    PrintDetails "dret(0) <> dret(1):", "The body is above the horizon"
Else
    PrintDetails "dret(0) = dret(1):", "The body is belowe the horizon"
End If

'Function returns():
'     case 1, conversion from true altitude to apparent altitude:
'o  apparent altitude, if body appears above is observable above ideal horizon;
'o  true altitude (the input value); otherwise "ideal horizon" is the horizon as seen above an ideal sphere (as seen from a plane over the ocean with a clear sky)

'     case 2, conversion from apparent altitude to true altitude:

'o  the true altitude resulting from the input apparent altitude, if this value is a plausible apparent altitude, i.e. if it is a position above the ideal horizon;
'o  the input altitude; otherwise in addition the array dret[] returns the following values:
'  dret[0] true altitude, if possible; otherwise input value;
'  dret[1] apparent altitude, if possible; otherwise input value;
'  dret[2] refraction;
'  dret[3] dip of the horizon.
'The body is above the horizon if the dret[0] != dret[1].

End Sub 'Test79()

Public Sub Test80()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  786]:     ext_def(void) swe_revjul(double jd,int gregflag,int *jyear, int *jmon, int *jday, double *jut);
'9.         Date and time conversion functions
'9.1.  Calendar date and Julian day: swe_julday(), swe_date_conversion(), /swe_revjul()
' It computes year, month, day and hour from a Julian day number.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "====================="
PrintDetails "Test[80]:swe_revjul()"
PrintDetails "====================="

Dim jd As Double              '//Julian Day Number
Dim gregflag As Long          '/*calendars Flag for Calculation.See User's manual */
Dim jyear As Long             '//Year of the Julianday Number
Dim jmon As Long              '//month of the Julianday Number
Dim jday As Long              '//Day of the Julianday Number
Dim jut As Double             '//Julianday UT Hours

jd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
'jd = jd + swe_deltat(jd)
gregflag = SE_GREG_CAL

Call swe_revjul(jd, gregflag, jyear, jmon, jday, jut)

PrintDetails "jd=", jd
PrintDetails "gregflag=", gregflag
PrintDetails "jyear=", jyear
PrintDetails "jmon=", jmon
PrintDetails "jday=", jday
PrintDetails "jut=", jut

End Sub 'Test80()


Public Sub Test81()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  923]:     ext_def(int32) swe_rise_trans(double tjd_ut, int32 ipl, char *starname, int32 epheflag, int32 rsmi,double *geopos, double atpress, double attemp,double *tret,char *serr);
'8.12.      swe_rise_trans() and swe_rise_trans_true_hor() (risings, settings, meridian transits)
'The function computes the times of rising, setting and meridian transits for
'all planets, asteroids, the moon, and the fixed stars.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[81]:swe_rise_trans()"
PrintDetails "========================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim ipl As Long               '//fixed set of body numbers
Dim starname As String        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
starname = Space$(256)        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim epheflag As Long          '/* ephemeris flag */
Dim rsmi As Long              '/* integer specifying that rise, set, or one of the two meridian transits is wanted. see definition User's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim atpress As Double         '/* atmospheric pressure in mbar/hPa */
Dim attemp As Double          '// atmospheric temperature in degrees Celsius
Dim tret(10) As Double        '//Time details /* return array, Array of 10 doubles, see User's manual */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ipl = 2
starname = ""
epheflag = SEFLG_MOSEPH 'SEFLG_SWIEPH  'SEFLG_JPLEPH '
rsmi = SE_CALC_RISE

lRet = swe_rise_trans(tjd_ut, ipl, starname, epheflag, rsmi, geopos(0), atpress, attemp, tret(0), serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "ipl=", ipl
PrintDetails "starname=", TrimNullChar(starname)
PrintDetails "epheflag=", epheflag
PrintDetails "rsmi=", rsmi
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test81()


Public Sub Test82()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  914]:     ext_def(int32) swe_rise_trans_true_hor(double tjd_ut, int32 ipl, char *starname, int32 epheflag, int32 rsmi,double *geopos, double atpress, double attemp, double horhgt,double *tret,char *serr);
'8.12.      swe_rise_trans() and swe_rise_trans_true_hor() (risings, settings, meridian transits)
'The function computes the times of rising, setting and meridian transits for
'all planets, asteroids, the moon, and the fixed stars for a local horizon that has an altitude != 0
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=================================="
PrintDetails "Test[82]:swe_rise_trans_true_hor()"
PrintDetails "=================================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim ipl As Long               '//fixed set of body numbers
Dim starname As String        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
starname = Space$(256)        '//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
Dim epheflag As Long          '/* ephemeris flag */
Dim rsmi As Long              '/* integer specifying that rise, set, or one of the two meridian transits is wanted. see definition User's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim atpress As Double         '/* atmospheric pressure in mbar/hPa */
Dim attemp As Double          '// atmospheric temperature in degrees Celsius
Dim horhgt As Double          '/* height of local horizon in deg at the point where the body rises or sets*/
Dim tret(10) As Double        '//Time details /* return array, Array of 10 doubles, see User's manual */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ipl = 2
starname = ""
epheflag = SEFLG_MOSEPH 'SEFLG_SWIEPH  'SEFLG_JPLEPH '
rsmi = SE_CALC_RISE
geopos(0) = 80#
geopos(1) = 13#
geopos(2) = 0
atpress = 10#
attemp = 35#
horhgt = 0#

lRet = swe_rise_trans_true_hor(tjd_ut, ipl, starname, epheflag, rsmi, geopos(0), atpress, attemp, horhgt, tret(0), serr)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "ipl=", ipl
PrintDetails "starname=", TrimNullChar(starname)
PrintDetails "epheflag=", epheflag
PrintDetails "rsmi=", rsmi
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "atpress=", atpress
PrintDetails "attemp=", attemp
PrintDetails "horhgt=", horhgt
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test82()


Public Sub Test83()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  691]:     ext_def(void) swe_set_astro_models(char *samod, int32 iflag);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==============================="
PrintDetails "Test[83]:swe_set_astro_models()"
PrintDetails "==============================="

Dim samod As String           '//Model Name for internal use only
samod = Space$(256)           '//Model Name for internal use only
Dim iflag As Long             '//Control Flag for internal use only

Call swe_set_astro_models(samod, iflag)

PrintDetails "samod=", TrimNullChar(samod)
PrintDetails "iflag=", iflag

PrintDetails "*WARNING:/* This function is obsolete/Internal use only */*******"

End Sub 'Test83()


Public Sub Test84()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  975]:     ext_def(void) swe_set_delta_t_userdef(double dt);
'10.4.      swe_set_delta_t_userdef()
'This function allows the user to set a fixed DeltaT value that will be
'returned by swe_deltat() or swe_deltat_ex().
'The same Delta T value will then be used by swe_calc_ut(), eclipse functions,
'heliacal functions, and all functions that require UT as input time.
'In order to return to automatic Delta T, call this function with the
'following value swe_set_delta_t_userdef(SE_DELTAT_AUTOMATIC)
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=================================="
PrintDetails "Test[84]:swe_set_delta_t_userdef()"
PrintDetails "=================================="

Dim dt As Double              '//Delt_T user Defined Value
dt = 65# / (3600# * 24) 'SE_DELTAT_AUTOMATIC
Call swe_set_delta_t_userdef(dt)

PrintDetails "dt=", dt

End Sub 'Test84()


Public Sub Test85()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  746]:     ext_def(void) swe_set_ephe_path(char *path);
'2.         The Ephemeris file related functions
'2.1.  swe_set_ephe_path()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "============================"
PrintDetails "Test[85]:swe_set_ephe_path()"
PrintDetails "============================"

Dim path As String            '//Set String  must be able to hold Required Size
path = Space$(256)            '//Set String  must be able to hold Required Size

path = sSWEPH_EPHE_PATH

Call swe_set_ephe_path(path)

PrintDetails "path=", TrimNullChar(path)

End Sub 'Test85()


Public Sub Test86()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  963]:     ext_def(void) swe_set_interpolate_nut(AS_BOOL do_interpolate);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=================================="
PrintDetails "Test[86]:swe_set_interpolate_nut()"
PrintDetails "=================================="

Dim do_interpolate As Long    '//For internal use

Call swe_set_interpolate_nut(do_interpolate)

PrintDetails "do_interpolate=", do_interpolate

PrintDetails "*WARNING:/* This function is obsolete/Internal use only */*******"

End Sub 'Test86()


Public Sub Test87()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  749]:     ext_def(void) swe_set_jpl_file(char *fname);
'2.         The Ephemeris file related functions
'2.3.  swe_set_jpl_file()
'/* set name of JPL ephemeris file */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==========================="
PrintDetails "Test[87]:swe_set_jpl_file()"
PrintDetails "==========================="

Dim fname As String           '//String  must be able to hold 256 bytes
fname = Space$(256)           '//String  must be able to hold 256 bytes

fname = SE_FNAME_DE431
Call swe_set_jpl_file(fname)

PrintDetails "fname=", TrimNullChar(fname)

End Sub 'Test87()


Public Sub Test88()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  896]:     ext_def(void) swe_set_lapse_rate(double lapse_rate);
'*WARNING:/* This function may be for inhouse testing only */*******
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "============================="
PrintDetails "Test[88]:swe_set_lapse_rate()"
PrintDetails "============================="

Dim lapse_rate As Double      '//Value internal use

lapse_rate = 10#
Call swe_set_lapse_rate(lapse_rate)

PrintDetails "lapse_rate=", lapse_rate

PrintDetails "*WARNING:/* This function is obsolete/Internal use only */*******"

End Sub 'Test88()


Public Sub Test89()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  758]:     ext_def(void) swe_set_sid_mode(int32 sid_mode, double t0, double ayan_t0);
'12.     Sidereal mode functions
'12.1.      swe_set_sid_mode()
'This function can be used to specify the mode for sidereal computations.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==========================="
PrintDetails "Test[89]:swe_set_sid_mode()"
PrintDetails "==========================="

Dim sid_mode As Long          '//Flag for sid. mode calculation, Ayanamsa etc.,
Dim t0 As Double              '//Julianday number t0 for ayan_t0
Dim ayan_t0 As Double         '//initial value of the ayanamsha (ayan_t0) user defined case

sid_mode = SE_SIDM_KRISHNAMURTI_VP291 '45
t0 = 0#
ayan_t0 = 0#

Call swe_set_sid_mode(sid_mode, t0, ayan_t0)

PrintDetails "sid_mode=", sid_mode
PrintDetails "t0=", t0
PrintDetails "ayan_t0=", ayan_t0

End Sub 'Test89()


Public Sub Test90()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  971]:     ext_def(void) swe_set_tid_acc(double t_acc);
'10.3.      swe_set_tid_acc(), swe_get_tid_acc()
'to set a different acceleration value.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[90]:swe_set_tid_acc()"
PrintDetails "=========================="

Dim t_acc As Double           '//tidal acceleration Value

t_acc = 34#
Call swe_set_tid_acc(t_acc)

PrintDetails "t_acc=", t_acc

End Sub 'Test90()


Public Sub Test91()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  755]:     ext_def(void) swe_set_topo(double geolon, double geolat, double geoalt);
'11.     The function swe_set_topo() for topocentric planet positions
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[91]:swe_set_topo()"
PrintDetails "======================="

Dim geolon As Double          '// geographic longitude,East is positive & West is negative
Dim geolat As Double          '// latitude,northern is positive & southern is negative
Dim geoalt As Double          '/* altitude of observer above sea level in meters */

geolon = 80#
geolat = 13#
geoalt = 0#
Call swe_set_topo(geolon, geolat, geoalt)

PrintDetails "geolon=", geolon
PrintDetails "geolat=", geolat
PrintDetails "geoalt=", geoalt

End Sub 'Test91()


Public Sub Test92()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  961]:     ext_def(double) swe_sidtime0(double tjd_ut, double eps, double nut);
'17.     Sidereal time with swe_sidtime() and swe_sidtime0()
'Use this function to calculate sidereal time separately.
'It requires obliquity and nutation to be given in the function call
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[92]:swe_sidtime0()"
PrintDetails "======================="

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim eps As Double             '//Obliquity of ecliptic, in Decimal degrees
Dim nut As Double             '/* nutation in longitude, in degrees */
Dim dret As Double            'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
eps = 23.45
nut = 15 / 3600#

dret = swe_sidtime0(tjd_ut, eps, nut)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "eps=", eps
PrintDetails "nut=", nut
PrintDetails "dRet=", dret

End Sub 'Test92()


Public Sub Test93()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  962]:     ext_def(double) swe_sidtime(double tjd_ut);
'17.     Sidereal time with swe_sidtime() and swe_sidtime0()
'Gives sidereal time at the Greenwich Meridian, measured in hours
'Use this function to calculate sidereal time separately.
'obliquity and nutation are calculated internally.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================"
PrintDetails "Test[93]:swe_sidtime()"
PrintDetails "======================"

Dim tjd_ut As Double          '//Julian day, universal time (UT)
Dim dret As Double            'Return value

tjd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)

dret = swe_sidtime(tjd_ut)

PrintDetails "tjd_ut=", tjd_ut
PrintDetails "dRet=", dret

End Sub 'Test93()


Public Sub Test94()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  857]:     ext_def(int32) swe_sol_eclipse_how(double tjd, int32 ifl, double *geopos, double *attr, char *serr);
'8.4.  swe_sol_eclipse_how ()
'To calculate the attributes of an eclipse for a given geographic position and time:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=============================="
PrintDetails "Test[94]:swe_sol_eclipse_how()"
PrintDetails "=============================="

Dim tjd As Double             '//Julian Day Number
Dim ifl As Long               '/*ephemeris Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ifl = SEFLG_MOSEPH
geopos(0) = 80#
geopos(1) = 13#
geopos(2) = 0#

lRet = swe_sol_eclipse_how(tjd, ifl, geopos(0), attr(0), serr)

PrintDetails "tjd=", tjd
PrintDetails "ifl=", ifl
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test94()


Public Sub Test95()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  866]:     ext_def(int32) swe_sol_eclipse_when_glob(double tjd_start, int32 ifl, int32 ifltype,double *tret, int32 backward, char *serr);
'8.3.  swe_sol_eclipse_when_glob()
'To find the next eclipse globally:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "===================================="
PrintDetails "Test[95]:swe_sol_eclipse_when_glob()"
PrintDetails "===================================="

Dim tjd_start As Double       '/* start date for search, Jul. day UT */
Dim ifl As Long               '/* ephemeris Flag for Calculation. See user's manual */
Dim ifltype As Long           '/* Flag for Calculation. See user's manual */
Dim tret(10) As Double        '//Time details /* return array, Array of 10 doubles, see User's manual */
Dim backward As Long          '/* TRUE, if backward search */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_start = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ifl = SEFLG_MOSEPH
ifltype = 0
backward = False

lRet = swe_sol_eclipse_when_glob(tjd_start, ifl, ifltype, tret(0), backward, serr)

PrintDetails "tjd_start=", tjd_start
PrintDetails "ifl=", ifl
PrintDetails "ifltype=", ifltype
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "backward=", backward
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test95()


Public Sub Test96()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  860]:     ext_def(int32) swe_sol_eclipse_when_loc(double tjd_start, int32 ifl, double *geopos, double *tret, double *attr, int32 backward, char *serr);
'8.         Eclipses, risings, settings, meridian transits, planetary phenomena
'finds the next eclipse for a given geographic position
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==================================="
PrintDetails "Test[96]:swe_sol_eclipse_when_loc()"
PrintDetails "==================================="

Dim tjd_start As Double       '/* start date for search, Jul. day UT */
Dim ifl As Long               '/* Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim tret(10) As Double        '//Time details /* return array, Array of 10 doubles, see User's manual */
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim backward As Long          '/* TRUE, if backward search */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd_start = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ifl = SEFLG_MOSEPH
geopos(0) = 80#
geopos(1) = 13#
geopos(2) = 0#
backward = False

lRet = swe_sol_eclipse_when_loc(tjd_start, ifl, geopos(0), tret(0), attr(0), backward, serr)

PrintDetails "tjd_start=", tjd_start
PrintDetails "ifl=", ifl
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "tret(0)=", tret(0)
PrintDetails "tret(1)=", tret(1)
PrintDetails "tret(2)=", tret(2)
PrintDetails "tret(3)=", tret(3)
PrintDetails "tret(4)=", tret(4)
PrintDetails "tret(5)=", tret(5)
PrintDetails "tret(6)=", tret(6)
PrintDetails "tret(7)=", tret(7)
PrintDetails "tret(8)=", tret(8)
PrintDetails "tret(9)=", tret(9)
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "backward=", backward
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test96()


Public Sub Test97()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  852]:     ext_def(int32) swe_sol_eclipse_where(double tjd, int32 ifl, double *geopos, double *attr, char *serr);
'8.5.  swe_sol_eclipse_where ()
'This function can be used to find out the geographic position, where,
'for a given time, a central eclipse is central or
'where a non-central eclipse is maximal.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "================================"
PrintDetails "Test[97]:swe_sol_eclipse_where()"
PrintDetails "================================"

Dim tjd As Double             '//Julian Day Number
Dim ifl As Long               '/* ephemeris Flag for Calculation. See user's manual */
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim attr(20) As Double        '/* return array of 20 doubles, see user's manual*/
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
ifl = SEFLG_MOSEPH
'geopos(0) = 80#
'geopos(1) = 13#
'geopos(2) = 0#

lRet = swe_sol_eclipse_where(tjd, ifl, geopos(0), attr(0), serr)

PrintDetails "tjd=", tjd
PrintDetails "ifl=", ifl
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "attr(0)=", attr(0)
PrintDetails "attr(1)=", attr(1)
PrintDetails "attr(2)=", attr(2)
PrintDetails "attr(3)=", attr(3)
PrintDetails "attr(4)=", attr(4)
PrintDetails "attr(5)=", attr(5)
PrintDetails "attr(6)=", attr(6)
PrintDetails "attr(7)=", attr(7)
PrintDetails "attr(8)=", attr(8)
PrintDetails "attr(9)=", attr(9)
PrintDetails "attr(10)=", attr(10)
PrintDetails "attr(11)=", attr(11)
PrintDetails "attr(12)=", attr(12)
PrintDetails "attr(13)=", attr(13)
PrintDetails "attr(14)=", attr(14)
PrintDetails "attr(15)=", attr(15)
PrintDetails "attr(16)=", attr(16)
PrintDetails "attr(17)=", attr(17)
PrintDetails "attr(18)=", attr(18)
PrintDetails "attr(19)=", attr(19)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test97()


Public Sub Test98()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  712]:     ext_def(double) swe_solcross(double x2cross, double jd_et, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Sun over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[98]:swe_solcross()"
PrintDetails "======================="

Dim x2cross As Double         '//heliocentric crossings over a position x2cross
Dim jd_et As Double           '//Julian day, Ephemeris time/TT
Dim flag As Long              '/* Flag for Calculation. See user's manual */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

x2cross = 120#
jd_et = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
jd_et = jd_et + swe_deltat(jd_et)
flag = 0

dret = swe_solcross(x2cross, jd_et, flag, serr)

PrintDetails "x2cross=", x2cross
PrintDetails "jd_et=", jd_et
PrintDetails "flag=", flag
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test98()


Public Sub Test99()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  713]:     ext_def(double) swe_solcross_ut(double x2cross, double jd_ut, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Sun over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "=========================="
PrintDetails "Test[99]:swe_solcross_ut()"
PrintDetails "=========================="

Dim x2cross As Double         '//heliocentric crossings over a position x2cross
Dim jd_ut As Double           '//Julian day, universal time (UT)
Dim flag As Long              '/* Flag for Calculation. See user's manual */
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim dret As Double            'Return value

x2cross = 120#
jd_ut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
flag = 0

dret = swe_solcross_ut(x2cross, jd_ut, flag, serr)

PrintDetails "x2cross=", x2cross
PrintDetails "jd_ut=", jd_ut
PrintDetails "flag=", flag
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "dRet=", dret

End Sub 'Test99()


Public Sub Test100()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  982]:     ext_def(void) swe_split_deg(double ddeg, int32 roundflag, int32 *ideg, int32 *imin, int32 *isec, double *dsecfr, int32 *isgn);
'18.6.6.      swe_split_deg(): split degrees to sign/nakshatra, degrees, minutes, seconds of arc
'This function takes a decimal degree number as input and provides
'sign or nakshatra, degree, minutes, seconds and fraction of second.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[100]:swe_split_deg()"
PrintDetails "========================="

Dim ddeg As Double            '//decimal degrees, ecliptic longitude
Dim roundflag As Long         '/* Flag for rounding Calculation.See user's manual*/
Dim ideg As Long              '//Integer part of Decimal Degree
Dim imin As Long              '//Integer minute part of  Decimal hour
Dim isec As Long              '//Integer Seconds part of  Decimal hour
Dim dsecfr As Double          '//fraction of seconds
Dim isgn As Long              '//sign or nakshatra Details

ddeg = 120.55
roundflag = 0

Call swe_split_deg(ddeg, roundflag, ideg, imin, isec, dsecfr, isgn)

PrintDetails "ddeg=", ddeg
PrintDetails "roundflag=", roundflag
PrintDetails "ideg=", ideg
PrintDetails "imin=", imin
PrintDetails "isec=", isec
PrintDetails "dsecfr=", dsecfr
PrintDetails "isgn=", isgn

End Sub 'Test100()


Public Sub Test101()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  956]:     ext_def(int32) swe_time_equ(double tjd, double *te, char *serr);
'9.4.  Mean solar time versus True solar time: swe_time_equ(), swe_lmt_to_lat(), swe_lat_to_lmt()
'Equation of Time: e = (LAT - LMT)
'returns the difference between local apparent and local mean time
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================"
PrintDetails "Test[101]:swe_time_equ()"
PrintDetails "========================"

Dim tjd As Double             '//Julian Day Number
Dim te As Double              '//Equation of time value
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjd = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)

lRet = swe_time_equ(tjd, te, serr)

PrintDetails "tjd=", tjd
PrintDetails "te=", te
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test101()


Public Sub Test102()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  687]:     ext_def(int32) swe_topo_arcus_visionis(double tjdut, double *dgeo, double *datm, double *dobs, int32 helflag, double mag, double azi_obj, double alt_obj, double azi_sun, double azi_moon, double alt_moon, double *dret, char *serr);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "==================================="
PrintDetails "Test[102]:swe_topo_arcus_visionis()"
PrintDetails "==================================="

Dim tjdut As Double           '//Julian day, universal time (UT)
Dim dgeo(3) As Double         '/* geographic position (details User's manual) */declare array of 3 doubles
Dim datm(10) As Double        '/* atmospheric conditions (details User's manual) */declare array of 10 doubles
Dim dobs(10) As Double        '/* observer description (details User's manual) */declare array of 10 doubles
Dim helflag As Long           '/* Flag for Calculation. See user's manual */
Dim mag As Double             '//For internal use
Dim azi_obj As Double         '//For internal use
Dim alt_obj As Double         '//For internal use
Dim azi_sun As Double         '//For internal use
Dim azi_moon As Double        '//For internal use
Dim alt_moon As Double        '//For internal use
Dim dret(50) As Double        '/* result: Return array, See User's manual */Declare array of 50 doubles
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjdut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
dgeo(0) = 80#
dgeo(1) = 13#
dgeo(2) = 0
helflag = 0

lRet = swe_topo_arcus_visionis(tjdut, dgeo(0), datm(0), dobs(0), helflag, mag, azi_obj, alt_obj, azi_sun, azi_moon, alt_moon, dret(0), serr)

PrintDetails "tjdut=", tjdut
PrintDetails "dgeo(0)=", dgeo(0)
PrintDetails "dgeo(1)=", dgeo(1)
PrintDetails "dgeo(2)=", dgeo(2)
PrintDetails "datm(0)=", datm(0)
PrintDetails "datm(1)=", datm(1)
PrintDetails "datm(2)=", datm(2)
PrintDetails "datm(3)=", datm(3)
PrintDetails "datm(4)=", datm(4)
PrintDetails "datm(5)=", datm(5)
PrintDetails "datm(6)=", datm(6)
PrintDetails "datm(7)=", datm(7)
PrintDetails "datm(8)=", datm(8)
PrintDetails "datm(9)=", datm(9)
PrintDetails "dobs(0)=", dobs(0)
PrintDetails "dobs(1)=", dobs(1)
PrintDetails "dobs(2)=", dobs(2)
PrintDetails "dobs(3)=", dobs(3)
PrintDetails "dobs(4)=", dobs(4)
PrintDetails "dobs(5)=", dobs(5)
PrintDetails "dobs(6)=", dobs(6)
PrintDetails "dobs(7)=", dobs(7)
PrintDetails "dobs(8)=", dobs(8)
PrintDetails "dobs(9)=", dobs(9)
PrintDetails "helflag=", helflag
PrintDetails "mag=", mag
PrintDetails "azi_obj=", azi_obj
PrintDetails "alt_obj=", alt_obj
PrintDetails "azi_sun=", azi_sun
PrintDetails "azi_moon=", azi_moon
PrintDetails "alt_moon=", alt_moon
PrintDetails "dret(0)=", dret(0)
PrintDetails "dret(1)=", dret(1)
PrintDetails "dret(2)=", dret(2)
PrintDetails "dret(3)=", dret(3)
PrintDetails "dret(4)=", dret(4)
PrintDetails "dret(5)=", dret(5)
PrintDetails "dret(6)=", dret(6)
PrintDetails "dret(7)=", dret(7)
PrintDetails "dret(8)=", dret(8)
PrintDetails "dret(9)=", dret(9)
PrintDetails "dret(10)=", dret(10)
PrintDetails "dret(11)=", dret(11)
PrintDetails "dret(12)=", dret(12)
PrintDetails "dret(13)=", dret(13)
PrintDetails "dret(14)=", dret(14)
PrintDetails "dret(15)=", dret(15)
PrintDetails "dret(16)=", dret(16)
PrintDetails "dret(17)=", dret(17)
PrintDetails "dret(18)=", dret(18)
PrintDetails "dret(19)=", dret(19)
PrintDetails "dret(20)=", dret(20)
PrintDetails "dret(21)=", dret(21)
PrintDetails "dret(22)=", dret(22)
PrintDetails "dret(23)=", dret(23)
PrintDetails "dret(24)=", dret(24)
PrintDetails "dret(25)=", dret(25)
PrintDetails "dret(26)=", dret(26)
PrintDetails "dret(27)=", dret(27)
PrintDetails "dret(28)=", dret(28)
PrintDetails "dret(29)=", dret(29)
PrintDetails "dret(30)=", dret(30)
PrintDetails "dret(31)=", dret(31)
PrintDetails "dret(32)=", dret(32)
PrintDetails "dret(33)=", dret(33)
PrintDetails "dret(34)=", dret(34)
PrintDetails "dret(35)=", dret(35)
PrintDetails "dret(36)=", dret(36)
PrintDetails "dret(37)=", dret(37)
PrintDetails "dret(38)=", dret(38)
PrintDetails "dret(39)=", dret(39)
PrintDetails "dret(40)=", dret(40)
PrintDetails "dret(41)=", dret(41)
PrintDetails "dret(42)=", dret(42)
PrintDetails "dret(43)=", dret(43)
PrintDetails "dret(44)=", dret(44)
PrintDetails "dret(45)=", dret(45)
PrintDetails "dret(46)=", dret(46)
PrintDetails "dret(47)=", dret(47)
PrintDetails "dret(48)=", dret(48)
PrintDetails "dret(49)=", dret(49)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

PrintDetails "WARNING:This function is obsolete/Internal use*******************"

End Sub 'Test102()


Public Sub Test103()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  806]:     ext_def(void) swe_utc_time_zone(int32 iyear, int32 imonth, int32 iday, int32 ihour, int32 imin, double dsec, double d_timezone, int32 *iyear_out, int32 *imonth_out, int32 *iday_out, int32 *ihour_out, int32 *imin_out, double *dsec_out);
'9.2.  UTC and Julian day: swe_utc_time_zone(), swe_utc_to_jd(), swe_jdet_to_utc(), swe_jdut1_to_utc()
'converts UTC int local time zone time.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "============================="
PrintDetails "Test[103]:swe_utc_time_zone()"
PrintDetails "============================="

Dim iyear As Long             '//Year of the date
Dim imonth As Long            '//Month of the date
Dim iday As Long              '//Day in the date
Dim ihour As Long             '//Hour part of the time
Dim imin As Long              '//minute part of the time
Dim dsec As Double            '//second is a decimal
Dim d_timezone As Double      '//timezone offset, east of Greenwich is positive & west of Greenwich is negative
Dim iyear_out As Long         '//Year in the date
Dim imonth_out As Long        '//Month in the date
Dim iday_out As Long          '//Day in the date
Dim ihour_out As Long         '//Integer part of  Decimal hour
Dim imin_out As Long          '//Integer minute part of  Decimal hour
Dim dsec_out As Double        '//Decimal Seconds

iyear = 2021
imonth = 10
iday = 1
ihour = 10
imin = 0
dsec = 0#
d_timezone = 5.5

Call swe_utc_time_zone(iyear, imonth, iday, ihour, imin, dsec, d_timezone, iyear_out, imonth_out, iday_out, ihour_out, imin_out, dsec_out)

PrintDetails "iyear=", iyear
PrintDetails "imonth=", imonth
PrintDetails "iday=", iday
PrintDetails "ihour=", ihour
PrintDetails "imin=", imin
PrintDetails "dsec=", dsec
PrintDetails "d_timezone=", d_timezone
PrintDetails "iyear_out=", iyear_out
PrintDetails "imonth_out=", imonth_out
PrintDetails "iday_out=", iday_out
PrintDetails "ihour_out=", ihour_out
PrintDetails "imin_out=", imin_out
PrintDetails "dsec_out=", dsec_out

End Sub 'Test103()


Public Sub Test104()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  791]:     ext_def(int32) swe_utc_to_jd(int32 iyear, int32 imonth, int32 iday, int32 ihour, int32 imin, double dsec, int32 gregflag, double *dret, char *serr);
'9.2.  UTC and Julian day: swe_utc_time_zone(), swe_utc_to_jd(), swe_jdet_to_utc(), swe_jdut1_to_utc()
'18.3.6.      UTC to jd (TT and UT1)
'/* calculate Julian day number in UT (UT1) and ET (TT) from UTC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "========================="
PrintDetails "Test[104]:swe_utc_to_jd()"
PrintDetails "========================="

Dim iyear As Long             '//Year of the date
Dim imonth As Long            '//Month of the date
Dim iday As Long              '//Day in the date
Dim ihour As Long             '//Hour part of the time
Dim imin As Long              '//minute part of the time
Dim dsec As Double            '//second is a decimal
Dim gregflag As Long          '/*calendars Flag for Calculation.See User's manual */
Dim dret(50) As Double        '/* result: Return array, See User's manual */Declare array of 50 doubles
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

iyear = 2021
imonth = 10
iday = 1
ihour = 10
imin = 0
dsec = 0#
gregflag = SE_GREG_CAL

lRet = swe_utc_to_jd(iyear, imonth, iday, ihour, imin, dsec, gregflag, dret(0), serr)

PrintDetails "iyear=", iyear
PrintDetails "imonth=", imonth
PrintDetails "iday=", iday
PrintDetails "ihour=", ihour
PrintDetails "imin=", imin
PrintDetails "dsec=", dsec
PrintDetails "gregflag=", gregflag
PrintDetails "dret(0)=", dret(0)
PrintDetails "dret(1)=", dret(1)
PrintDetails "dret(2)=", dret(2)
PrintDetails "dret(3)=", dret(3)
PrintDetails "dret(4)=", dret(4)
PrintDetails "dret(5)=", dret(5)
PrintDetails "dret(6)=", dret(6)
PrintDetails "dret(7)=", dret(7)
PrintDetails "dret(8)=", dret(8)
PrintDetails "dret(9)=", dret(9)
PrintDetails "dret(10)=", dret(10)
PrintDetails "dret(11)=", dret(11)
PrintDetails "dret(12)=", dret(12)
PrintDetails "dret(13)=", dret(13)
PrintDetails "dret(14)=", dret(14)
PrintDetails "dret(15)=", dret(15)
PrintDetails "dret(16)=", dret(16)
PrintDetails "dret(17)=", dret(17)
PrintDetails "dret(18)=", dret(18)
PrintDetails "dret(19)=", dret(19)
PrintDetails "dret(20)=", dret(20)
PrintDetails "dret(21)=", dret(21)
PrintDetails "dret(22)=", dret(22)
PrintDetails "dret(23)=", dret(23)
PrintDetails "dret(24)=", dret(24)
PrintDetails "dret(25)=", dret(25)
PrintDetails "dret(26)=", dret(26)
PrintDetails "dret(27)=", dret(27)
PrintDetails "dret(28)=", dret(28)
PrintDetails "dret(29)=", dret(29)
PrintDetails "dret(30)=", dret(30)
PrintDetails "dret(31)=", dret(31)
PrintDetails "dret(32)=", dret(32)
PrintDetails "dret(33)=", dret(33)
PrintDetails "dret(34)=", dret(34)
PrintDetails "dret(35)=", dret(35)
PrintDetails "dret(36)=", dret(36)
PrintDetails "dret(37)=", dret(37)
PrintDetails "dret(38)=", dret(38)
PrintDetails "dret(39)=", dret(39)
PrintDetails "dret(40)=", dret(40)
PrintDetails "dret(41)=", dret(41)
PrintDetails "dret(42)=", dret(42)
PrintDetails "dret(43)=", dret(43)
PrintDetails "dret(44)=", dret(44)
PrintDetails "dret(45)=", dret(45)
PrintDetails "dret(46)=", dret(46)
PrintDetails "dret(47)=", dret(47)
PrintDetails "dret(48)=", dret(48)
PrintDetails "dret(49)=", dret(49)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test104()


Public Sub Test105()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  698]:     ext_def(char *) swe_version(char *);
'2.4.  swe_version()
'/* find out version number of your Swiss Ephemeris version */
'returns the version of the Swiss Ephemeris
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "======================="
PrintDetails "Test[105]:swe_version()"
PrintDetails "======================="

Dim s As String               '//Return String  must be able to hold 256 bytes
s = Space$(256)               '//Return String  must be able to hold 256 bytes
Dim lpCHARA As Long           'Return Pointer to Char
Dim sRetText As String        'Return Text

lpCHARA = swe_version_LPCHARA(s)

'PrintDetails "lpCHARA=", lpCHARA
sRetText = GetStrFromLPCHARA(lpCHARA)
PrintDetails "sRetText =", sRetText
PrintDetails "s=", TrimNullChar(s)

End Sub 'Test105()


Public Sub Test106()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  683]:     ext_def(int32) swe_vis_limit_mag(double tjdut, double *geopos, double *datm, double *dobs, char *ObjectName, int32 helflag, double *dret, char *serr);
'8.18.      Magnitude limit for visibility: swe_vis_limit_mag()
'This function determines the limiting visual magnitude in dark skies.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintDetails "============================="
PrintDetails "Test[106]:swe_vis_limit_mag()"
PrintDetails "============================="

Dim tjdut As Double           '//Julian day, universal time (UT)
Dim geopos(3) As Double       '/* array of 3 doubles containing geographic lon, lat, height*/
Dim datm(10) As Double        '/* atmospheric conditions (details User's manual) */declare array of 10 doubles
Dim dobs(10) As Double        '/* observer description (details User's manual) */declare array of 10 doubles
Dim ObjectName As String      '/* name string of fixed star or planet */ Name Size 40 Chars?
ObjectName = Space$(256)      '/* name string of fixed star or planet */ Name Size 40 Chars?
Dim helflag As Long           '/* Flag for Calculation. See user's manual */
Dim dret(50) As Double        '/* result: Return array, See User's manual */Declare array of 50 doubles
Dim serr As String            '//Return Error String  must be able to hold 256 bytes
serr = Space$(256)            '//Return Error String  must be able to hold 256 bytes
Dim lRet As Long              'Return value

tjdut = swe_julday(2021, 10, 1, 10, SE_GREG_CAL)
geopos(0) = 80#
geopos(1) = 13#
geopos(2) = 0
ObjectName = "mars"
helflag = 0

lRet = swe_vis_limit_mag(tjdut, geopos(0), datm(0), dobs(0), ObjectName, helflag, dret(0), serr)

PrintDetails "tjdut=", tjdut
PrintDetails "geopos(0)=", geopos(0)
PrintDetails "geopos(1)=", geopos(1)
PrintDetails "geopos(2)=", geopos(2)
PrintDetails "datm(0)=", datm(0)
PrintDetails "datm(1)=", datm(1)
PrintDetails "datm(2)=", datm(2)
PrintDetails "datm(3)=", datm(3)
PrintDetails "datm(4)=", datm(4)
PrintDetails "datm(5)=", datm(5)
PrintDetails "datm(6)=", datm(6)
PrintDetails "datm(7)=", datm(7)
PrintDetails "datm(8)=", datm(8)
PrintDetails "datm(9)=", datm(9)
PrintDetails "dobs(0)=", dobs(0)
PrintDetails "dobs(1)=", dobs(1)
PrintDetails "dobs(2)=", dobs(2)
PrintDetails "dobs(3)=", dobs(3)
PrintDetails "dobs(4)=", dobs(4)
PrintDetails "dobs(5)=", dobs(5)
PrintDetails "dobs(6)=", dobs(6)
PrintDetails "dobs(7)=", dobs(7)
PrintDetails "dobs(8)=", dobs(8)
PrintDetails "dobs(9)=", dobs(9)
PrintDetails "ObjectName=", TrimNullChar(ObjectName)
PrintDetails "helflag=", helflag
PrintDetails "dret(0)=", dret(0)
PrintDetails "dret(1)=", dret(1)
PrintDetails "dret(2)=", dret(2)
PrintDetails "dret(3)=", dret(3)
PrintDetails "dret(4)=", dret(4)
PrintDetails "dret(5)=", dret(5)
PrintDetails "dret(6)=", dret(6)
PrintDetails "dret(7)=", dret(7)
PrintDetails "dret(8)=", dret(8)
PrintDetails "dret(9)=", dret(9)
PrintDetails "dret(10)=", dret(10)
PrintDetails "dret(11)=", dret(11)
PrintDetails "dret(12)=", dret(12)
PrintDetails "dret(13)=", dret(13)
PrintDetails "dret(14)=", dret(14)
PrintDetails "dret(15)=", dret(15)
PrintDetails "dret(16)=", dret(16)
PrintDetails "dret(17)=", dret(17)
PrintDetails "dret(18)=", dret(18)
PrintDetails "dret(19)=", dret(19)
PrintDetails "dret(20)=", dret(20)
PrintDetails "dret(21)=", dret(21)
PrintDetails "dret(22)=", dret(22)
PrintDetails "dret(23)=", dret(23)
PrintDetails "dret(24)=", dret(24)
PrintDetails "dret(25)=", dret(25)
PrintDetails "dret(26)=", dret(26)
PrintDetails "dret(27)=", dret(27)
PrintDetails "dret(28)=", dret(28)
PrintDetails "dret(29)=", dret(29)
PrintDetails "dret(30)=", dret(30)
PrintDetails "dret(31)=", dret(31)
PrintDetails "dret(32)=", dret(32)
PrintDetails "dret(33)=", dret(33)
PrintDetails "dret(34)=", dret(34)
PrintDetails "dret(35)=", dret(35)
PrintDetails "dret(36)=", dret(36)
PrintDetails "dret(37)=", dret(37)
PrintDetails "dret(38)=", dret(38)
PrintDetails "dret(39)=", dret(39)
PrintDetails "dret(40)=", dret(40)
PrintDetails "dret(41)=", dret(41)
PrintDetails "dret(42)=", dret(42)
PrintDetails "dret(43)=", dret(43)
PrintDetails "dret(44)=", dret(44)
PrintDetails "dret(45)=", dret(45)
PrintDetails "dret(46)=", dret(46)
PrintDetails "dret(47)=", dret(47)
PrintDetails "dret(48)=", dret(48)
PrintDetails "dret(49)=", dret(49)
PrintDetails "serr=", TrimNullChar(serr)
PrintDetails "lRet=", lRet

End Sub 'Test106()

Private Sub Class_Initialize()
FileOUT = 1 'dump results to the file
sSWEPH_EPHE_PATH = ActiveWorkbook.path + SE_EPHE_PATH
sTESTFILEPATH = ActiveWorkbook.path + "\TestSwedll32.txt"
If IsFolderExists(sSWEPH_EPHE_PATH) Then
    Call swe_set_ephe_path(sSWEPH_EPHE_PATH)
Else
    MsgBox sSWEPH_EPHE_PATH, vbCritical, "Folder doesn't exist"
End If
End Sub

Private Sub Class_Terminate()

Dim sFilePath As String
Dim iFileNo As Integer
sFilePath = sTESTFILEPATH
iFileNo = FreeFile
Open sFilePath For Append As #iFileNo
'if the filesize is less than 325 bytes then write header else
'it assumes that the header is already written and ignore writing
If LOF(iFileNo) > 325 Then
    Print #iFileNo, "##############################Test Finished##########################"
End If
Close #iFileNo

End Sub
